% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R, R/aliases.R
\name{bs4Quote}
\alias{bs4Quote}
\alias{blockQuote}
\title{Boostrap 4 block quote}
\usage{
bs4Quote(..., color)

blockQuote(..., color)
}
\arguments{
\item{...}{Content.}

\item{color}{Block color.  Valid colors are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
  \item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
  \item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
  \item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
  \item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
  \item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
  \item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
  \item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
  \item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
  \item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
  \item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
  \item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
  \item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
  \item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}
}
\description{
Build a bootstrap 4 block quote
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shinyApp(
  ui = dashboardPage(
    header = dashboardHeader(), 
    sidebar = dashboardSidebar(),
    body = dashboardBody(
     fluidRow(
      blockQuote("Blablabla", color = "indigo"),
      blockQuote("Blablabla", color = "danger"),
      blockQuote("Blablabla", color = "teal"),
      blockQuote("Blablabla", color = "orange"),
      blockQuote("Blablabla", color = "warning"),
      blockQuote("Blablabla", color = "fuchsia")
     )
    ), 
    footer = dashboardFooter()
  ),
  server = function(input, output) { }
 )
}


}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
