% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-functions.R, R/dashboardControlbar.R,
%   R/aliases.R
\name{updatebs4TabSetPanel}
\alias{updatebs4TabSetPanel}
\alias{updatebs4ControlbarMenu}
\alias{updateTabsetPanel}
\title{Update a \link{bs4TabSetPanel}}
\usage{
updatebs4TabSetPanel(session, inputId, selected = NULL)

updatebs4ControlbarMenu(session, inputId, selected = NULL)

updateTabsetPanel(session, inputId, selected = NULL)
}
\arguments{
\item{session}{shiny session.}

\item{inputId}{\link{bs4TabSetPanel} unique id.}

\item{selected}{the tab to be selected.}
}
\description{
Update a \link{bs4TabSetPanel}

Alias to \link{updatebs4TabSetPanel}
See \link{updatebs4TabSetPanel} for full details
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 
 shinyApp(
  ui = bs4DashPage(
   sidebar_collapsed = FALSE,
   controlbar_collapsed = TRUE,
   enable_preloader = FALSE,
   loading_duration =  2,
   navbar = bs4DashNavbar(skin = "dark"),
   body = bs4DashBody(
     bs4TabSetPanel(
       id = "tabset1",
       side = "left",
       bs4TabPanel(
         tabName = "Tab 1", 
         active = FALSE,
         numericInput("val", "Value:", 10, min = 1, max = 100),
         verbatimTextOutput("value")
       ),
       bs4TabPanel(
         tabName = "Tab 2", 
         active = TRUE,
         "Content 2"
       ),
       bs4TabPanel(
         tabName = "Tab 3", 
         active = FALSE,
         checkboxGroupInput(
           inline = TRUE,
           "variable", "Variables to show:",
           c("Cylinders" = "cyl",
             "Transmission" = "am",
             "Gears" = "gear")
         ),
         tableOutput("data")
       )
     ),
     bs4TabSetPanel(
       id = "tabset2",
       side = "left",
       vertical = TRUE,
       bs4TabPanel(
         tabName = "Tab 1", 
         active = FALSE,
         sliderInput(
           "obs", 
           "Number of observations:",
           min = 0,
           max = 1000, 
           value = 500
         ),
         plotOutput("distPlot")
       ),
       bs4TabPanel(
         tabName = "Tab 2", 
         active = TRUE,
         radioButtons(
           inline = TRUE,
           "rb", "Choose one:",
           choiceNames = list(
             icon("calendar"),
             HTML("<p style='color:red;'>Red Text</p>"),
             "Normal text"
           ),
           choiceValues = list(
             "icon", "html", "text"
           )
         ),
         textOutput("txt")
       ),
       bs4TabPanel(
         tabName = "Tab 3", 
         active = FALSE,
         "Content 3"
       )
     )
   ),
   sidebar = bs4DashSidebar(
     skin = "light",
     sliderInput(
       inputId = "controller",
       label = "Update the first tabset",
       min = 1,
       max = 3,
       value = 2
     ),
     br(),
     sliderInput(
       inputId = "controller2",
       label = "Update the second tabset",
       min = 1,
       max = 3,
       value = 3
     )
   ),
   controlbar = bs4DashControlbar(skin = "light"),
   footer = bs4DashFooter()
 ),
 server = function(input, output, session) {
   
   # update tabset1
   observeEvent(input$controller, {
     updatebs4TabSetPanel(
       session, 
       inputId = "tabset1", 
       selected = input$controller
     )
   })
   
   # update tabset 2
   observeEvent(input$controller2, {
     updatebs4TabSetPanel(
       session, 
       inputId = "tabset2", 
       selected = input$controller2
     )
   })
   
   output$distPlot <- renderPlot({
     hist(rnorm(input$obs))
   })
   
   output$data <- renderTable({
     mtcars[, c("mpg", input$variable), drop = FALSE]
   }, rownames = TRUE)
   
   output$txt <- renderText({
     paste("You chose", input$rb)
   })
   
   output$value <- renderText({ input$val })
   
  }
 )
}
}
