% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/intrinsic.R
\name{IntrinsicInference}
\alias{IntrinsicInference}
\alias{intrinsic_H0}
\alias{intrinsic_bounds}
\alias{intrinsic_estimate}
\alias{intrinsic_phi0}
\alias{intrinsic_phi0_sims}
\title{Intrinsic inference on the rate ratio.}
\usage{
intrinsic_phi0(phi0, x, y, S, T, a = 0.5, b = 0, c = 0.5, d = 0,
  beta_range = TRUE, tol = 1e-08, ...)

intrinsic_phi0_sims(phi0, x, y, S, T, a = 0.5, b = 0, c = 0.5, d = 0,
  nsims = 1e+06)

intrinsic_estimate(x, y, S, T, a = 0.5, b = 0, c = 0.5, d = 0,
  otol = 1e-08, ...)

intrinsic_H0(phi.star, alternative, x, y, S, T, a = 0.5, b = 0, c = 0.5,
  d = 0, ...)

intrinsic_bounds(x, y, S, T, a = 0.5, b = 0, c = 0.5, d = 0,
  conf = 0.95, parameter = "phi", otol = 1e-08, ...)
}
\arguments{
\item{phi0}{the proxy value of \code{phi}}

\item{x,y}{Observed counts}

\item{S,T}{sample sizes}

\item{a,b,c,d}{Prior parameters}

\item{beta_range}{logical, if \code{TRUE} (default), an internal method is used to avoid a possible failure in numerical integration; see the main vignette for details}

\item{tol}{accuracy requested}

\item{...}{other arguments passed to \code{\link{integrate}}}

\item{nsims}{number of simulations}

\item{otol}{desired accuracy for optimization}

\item{phi.star}{the hypothesized value of \code{phi}}

\item{alternative}{alternative hypothesis, "less" for H1: \code{phi0 < phi.star},
"greater" for  H1: \code{phi0 > phi.star}}

\item{conf}{credibility level}

\item{parameter}{parameter of interest: relative risk \code{"phi"} or vaccine efficacy \code{"VE"}}
}
\value{
\code{intrinsic_phi0} returns the posterior expected loss,
\code{intrinsic_estimate} returns the intrinsic estimate,
\code{intrinsic_H0} performs intrinsic hypothesis testing, and
\code{intrinsic_bounds} returns the intrinsic credibility interval.
}
\description{
Intrinsic inference on the rate ratio.










}
\examples{
a<-0.5; b<-0; c<-1/2; d<-0; S<-100; T<-S; x<-0; y<-20
intrinsic_phi0(0.5, x, y, S, T, a, b, c, d)
intrinsic_phi0_sims(0.5, x, y, S, T, a, b, c, d)
intrinsic_estimate(x, y, S, T, a, b, c, d)
bounds <- intrinsic_bounds(x, y, S, T, a, b, c, d, conf=0.95); bounds
ppost_phi(bounds[2], a, b, c, d, S, T,  x, y)- ppost_phi(bounds[1], a, b, c, d, S, T, x, y)
}

