% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_glance.R
\name{grouped_glance}
\alias{grouped_glance}
\title{Model summary output from grouped analysis of any function that has
\code{data} argument in its function call.}
\usage{
grouped_glance(data, grouping.vars, ..f, ...)
}
\arguments{
\item{data}{Dataframe (or tibble) from which variables are to be taken.}

\item{grouping.vars}{Grouping variables.}

\item{..f}{A function, or function name as a string.}

\item{...}{Arguments to function.

These dots support \link{tidy-dots} features.}
}
\description{
Model summary output from grouped analysis of any function that has
\code{data} argument in its function call.
}
\section{Methods}{


\Sexpr[stage=render,results=rd]{generics:::methods_rd("glance")}

}

\examples{
set.seed(123)
# to speed up computation, let's use only 50\% of the data

# linear model
broomExtra::grouped_glance(
  data = dplyr::sample_frac(tbl = ggplot2::diamonds, size = 0.5),
  grouping.vars = c(cut, color),
  formula = price ~ carat - 1,
  ..f = stats::lm,
  na.action = na.omit
)

# linear mixed effects model
broomExtra::grouped_glance(
  data = dplyr::sample_frac(tbl = ggplot2::diamonds, size = 0.5),
  grouping.vars = cut,
  ..f = lme4::lmer,
  formula = price ~ carat + (carat | color) - 1,
  control = lme4::lmerControl(optimizer = "bobyqa")
)
}
\author{
Indrajeet Patil
}
