% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-anova-tidiers.R
\name{tidy.manova}
\alias{tidy.manova}
\title{Tidy a(n) manova object}
\usage{
\method{tidy}{manova}(x, test = "Pillai", ...)
}
\arguments{
\item{x}{A \code{manova} object return from \code{\link[stats:manova]{stats::manova()}}.}

\item{test}{One of "Pillai" (Pillai's trace), "Wilks" (Wilk's lambda),
"Hotelling-Lawley" (Hotelling-Lawley trace) or "Roy" (Roy's greatest root)
indicating which test statistic should be used. Defaults to "Pillai".}

\item{...}{
  Arguments passed on to \code{\link[stats:summary.manova]{stats::summary.manova}}
  \describe{
    \item{\code{object}}{An object of class \code{"manova"} or an \code{aov}
    object with multiple responses.}
    \item{\code{intercept}}{logical.  If \code{TRUE}, the intercept term is
    included in the table.}
    \item{\code{tol}}{tolerance to be used in deciding if the residuals are
    rank-deficient: see \code{\link{qr}}.}
  }}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
Depending on which test statistic is specified only one of \code{pillai},
\code{wilks}, \code{hl} or \code{roy} is included.
}
\examples{

npk2 <- within(npk, foo <- rnorm(24))
m <- manova(cbind(yield, foo) ~ block + N * P * K, npk2)
tidy(m)
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:summary.manova]{stats::summary.manova()}}

Other anova tidiers: 
\code{\link{glance.anova}()},
\code{\link{glance.aov}()},
\code{\link{tidy.TukeyHSD}()},
\code{\link{tidy.anova}()},
\code{\link{tidy.aovlist}()},
\code{\link{tidy.aov}()}
}
\concept{anova tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{den.df}{Degrees of freedom of the denominator.}
  \item{num.df}{Degrees of freedom.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{term}{The name of the regression term.}
  \item{pillai}{Pillai's trace.}
  \item{wilks}{Wilk's lambda.}
  \item{hl}{Hotelling-Lawley trace.}
  \item{roy}{Roy's greatest root.}

}
