% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-factanal-tidiers.R
\name{glance.factanal}
\alias{glance.factanal}
\title{Glance at a(n) factanal object}
\usage{
\method{glance}{factanal}(x, ...)
}
\arguments{
\item{x}{A \code{factanal} object created by \code{\link[stats:factanal]{stats::factanal()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:

\item{n.factors}{The number of fitted factors}
\item{total.variance}{Total cumulative proportion of variance accounted
for by all factors}
\item{statistic}{Significance-test statistic}
\item{p.value}{p-value from the significance test, describing whether the
covariance matrix estimated from the factors is significantly different
from the observed covariance matrix}
\item{df}{Degrees of freedom used by the factor analysis}
\item{n}{Sample size used in the analysis}
\item{method}{The estimation method; always Maximum Likelihood, "mle"}
\item{converged}{Whether the factor analysis converged}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modelling
function. This includes the name of the modelling function or any
arguments passed to the modelling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.
}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[stats:factanal]{stats::factanal()}}

Other factanal tidiers: \code{\link{augment.factanal}},
  \code{\link{tidy.factanal}}
}
\concept{factanal tidiers}
