% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamlss_tidiers.R
\name{gamlss_tidiers}
\alias{gamlss_tidiers}
\alias{tidy.gamlss}
\title{Tidying methods for gamlss objects}
\usage{
\method{tidy}{gamlss}(x, quick = FALSE, ...)
}
\arguments{
\item{x}{A "gamlss" object}

\item{quick}{Whether to perform a fast version, and return only the coefficients}

\item{...}{Extra arguments (not used)}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

A data.frame with one row for each coefficient, containing columns
  \item{parameter}{Type of coefficient being estimated: \code{mu}, \code{sigma},
  \code{nu}, or \code{tau}}
  \item{term}{The term in the model being estimated and tested}
  \item{estimate}{The estimated coefficient}
  \item{std.error}{The standard error from the linear model}
  \item{statistic}{t-statistic}
  \item{p.value}{two-sided p-value}

if (requireNamespace("gamlss", quietly = TRUE)) {
    data(abdom)
    mod<-gamlss(y~pb(x),sigma.fo=~pb(x),family=BCT, data=abdom, method=mixed(1,20))
    
    tidy(mod)
}
}
\description{
Tidying methods for "gamlss" objects from the gamlss package.
}

