% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{standata.brmsfit}
\alias{standata.brmsfit}
\alias{standata}
\alias{standata.brmsfit}
\title{Extract Data passed to Stan}
\usage{
\method{standata}{brmsfit}(object, newdata = NULL, re_formula = NULL,
  incl_autocor = TRUE, new_objects = list(), internal = FALSE,
  control = list(), ...)

standata(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the original data of the model is used.}

\item{re_formula}{formula containing group-level effects 
to be considered in the prediction. 
If \code{NULL} (default), include all group-level effects; 
if \code{NA}, include no group-level effects.}

\item{incl_autocor}{A flag indicating if ARMA autocorrelation
parameters should be included in the predictions. Defaults to 
\code{TRUE}. Setting it to \code{FALSE} will not affect other 
correlation structures such as \code{\link[brms:cor_bsts]{cor_bsts}},
or \code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{new_objects}{A named \code{list} of objects containing 
new data, which cannot be passed via argument \code{newdata}.
Currently, only required for objects passed to 
\code{\link[brms:cor_sar]{cor_sar}} and 
\code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{internal}{Logical, indicates if the data should be prepared 
for internal use in other post-processing methods.}

\item{control}{A named list currently for internal usage only.}

\item{...}{More arguments passed to \code{\link{make_standata}}.}
}
\value{
A named list containing the data originally passed to Stan.
}
\description{
Extract all data that was used by Stan to fit the model
}
