% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{post_prob.brmsfit}
\alias{post_prob.brmsfit}
\alias{post_prob}
\title{Posterior Model Probabilities from Marginal Likelihoods}
\usage{
\method{post_prob}{brmsfit}(x, ..., prior_prob = NULL, model_names = NULL)
}
\arguments{
\item{x}{A fitted model object.}

\item{...}{More fitted model objects or further arguments
passed to the underlying post-processing functions.}

\item{prior_prob}{Numeric vector with prior model probabilities. 
If omitted, a uniform prior is used (i.e., all models are equally 
likely a priori). The default \code{NULL} corresponds to equal 
prior model weights.}

\item{model_names}{If \code{NULL} (the default) will use model names 
derived from deparsing the call. Otherwise will use the passed 
values as model names.}
}
\description{
Compute posterior model probabilities from marginal likelihoods.
The \code{brmsfit} method is just a thin wrapper around
the corresponding method for \code{bridge} objects.
}
\details{
Computing the marginal likelihood requires samples 
  of all variables defined in Stan's \code{parameters} block
  to be saved. Otherwise \code{post_prob} cannot be computed.
  Thus, please set \code{save_all_pars = TRUE} in the call to \code{brm},
  if you are planning to apply \code{post_prob} to your models.

  More details are provided under 
  \code{\link[bridgesampling:post_prob]{post_prob}}.
}
\examples{
\dontrun{
# model with the treatment effect
fit1 <- brm(
  count ~ log_Age_c + log_Base4_c + Trt_c,
  data = epilepsy, family = negbinomial(), 
  prior = prior(normal(0, 1), class = b),
  save_all_pars = TRUE
)
summary(fit1)

# model without the treatent effect
fit2 <- brm(
  count ~ log_Age_c + log_Base4_c,
  data = epilepsy, family = negbinomial(), 
  prior = prior(normal(0, 1), class = b),
  save_all_pars = TRUE
)
summary(fit2)

# compute the posterior model probabilities
post_prob(fit1, fit2)

# specify prior model probabilities
post_prob(fit1, fit2, prior_prob = c(0.8, 0.2))
}

}
\seealso{
\code{
  \link[brms:bridge_sampler]{bridge_sampler},
  \link[brms:bayes_factor]{bayes_factor}
}
}
