% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{model_weights.brmsfit}
\alias{model_weights.brmsfit}
\alias{model_weights}
\title{Model Weighting Methods}
\usage{
\method{model_weights}{brmsfit}(x, ..., weights = "loo2",
  model_names = NULL)

model_weights(x, ...)
}
\arguments{
\item{x}{A \code{brmsfit} object.}

\item{...}{More \code{brmsfit} objects or further arguments
passed to the underlying post-processing functions.
In particular, see \code{\link{extract_draws}} for further
supported arguments.}

\item{weights}{Name of the criterion to compute weights from. 
Should be one of \code{"loo"}, \code{"waic"}, \code{"kfold"}, 
\code{"loo2"} (current default), or \code{"marglik"}. 
For the former three options, Akaike weights will be computed
based on the information criterion values returned by
the respective methods. For \code{"loo2"}, method
\code{\link{loo_model_weights}} will be used to obtain weights. 
For \code{"marglik"}, method \code{\link{post_prob}} 
will be used to compute weights based on log marginal 
likelihood values (make sure to specify reasonable priors in 
this case). Alternatively, \code{weights} can be a numeric vector 
of pre-specified weights.}

\item{model_names}{If \code{NULL} (the default) will use model names 
derived from deparsing the call. Otherwise will use the passed 
values as model names.}
}
\value{
A numeric vector of weights for the models.
}
\description{
Compute model weights in various ways, for instance via
stacking of predictive distributions, Akaike weights, or
marginal likelihoods.
}
\examples{
\dontrun{
# model with 'treat' as predictor
fit1 <- brm(rating ~ treat + period + carry, data = inhaler)
summary(fit1)

# model without 'treat' as predictor
fit2 <- brm(rating ~ period + carry, data = inhaler)
summary(fit2)

# obtain Akaike weights based on the WAIC
model_weights(fit1, fit2, weights = "waic")
}

}
