% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-helpers.R
\name{mo}
\alias{mo}
\alias{mono}
\alias{monotonic}
\title{Monotonic Predictors in \pkg{brms} Models}
\usage{
mo(expr)
}
\arguments{
\item{expr}{Expression containing predictors,
for which monotonic effects should
be estimated. For evaluation, \R formula syntax is applied.}
}
\description{
Monotonic Predictors in \pkg{brms} Models
}
\details{
For detailed documentation see \code{help(brmsformula)}
  as well as \code{vignette("brms_monotonic")}.

This function is almost solely useful when
called in formulas passed to the \pkg{brms} package.
}
\examples{
  
\dontrun{
# generate some data
income_options <- c("below_20", "20_to_40", "40_to_100", "greater_100")
income <- factor(sample(income_options, 100, TRUE), 
                 levels = income_options, ordered = TRUE)
mean_ls <- c(30, 60, 70, 75)
ls <- mean_ls[income] + rnorm(100, sd = 7)
dat <- data.frame(income, ls)

# fit a simple monotonic model
fit <- brm(ls ~ mo(income), data = dat)

# summarise the model
summary(fit)
plot(fit, N = 6)
plot(marginal_effects(fit), points = TRUE)
} 
 
}
\seealso{
\code{\link[brms:brmsformula]{brmsformula}}
}
