% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{WAIC.brmsfit}
\alias{WAIC.brmsfit}
\alias{WAIC}
\alias{WAIC.brmsfit}
\alias{waic.brmsfit}
\alias{waic}
\title{Compute the WAIC}
\usage{
\method{WAIC}{brmsfit}(x, ..., compare = TRUE, newdata = NULL,
  re_formula = NULL, allow_new_levels = FALSE, subset = NULL,
  nsamples = NULL, pointwise = NULL)

WAIC(x, ...)
}
\arguments{
\item{x}{A fitted model object typically of class \code{brmsfit}.}

\item{...}{Optionally more fitted model objects.}

\item{compare}{A flag indicating if the information criteria
of the models should be compared to each other
via \code{\link[brms:compare_ic]{compare_ic}}.}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the orginal data of the model is used.}

\item{re_formula}{formula containing group-level effects 
to be considered in the prediction. 
If \code{NULL} (default), include all group-level effects; 
if \code{NA}, include no group-level effects.}

\item{allow_new_levels}{A flag indicating if new
levels of group-level effects are allowed 
(defaults to \code{FALSE}). 
Only relevant if \code{newdata} is provided.}

\item{subset}{A numeric vector specifying
the posterior samples to be used. 
If \code{NULL} (the default), all samples are used.}

\item{nsamples}{Positive integer indicating how many 
posterior samples should be used. 
If \code{NULL} (the default) all samples are used.
Ignored if \code{subset} is not \code{NULL}.}

\item{pointwise}{A flag indicating whether to compute the full
log-likelihood matrix at once or separately for each observation. 
The latter approach is usually considerably slower but 
requires much less working memory. Accordingly, if one runs 
into memory issues, \code{pointwise = TRUE} is the way to go.
By default, \code{pointwise} is automatically chosen based on 
the size of the model.}
}
\value{
If just one object is provided, an object of class \code{ic}. 
 If multiple objects are provided, an object of class \code{iclist}.
}
\description{
Compute the widely applicable information criterion (WAIC)
based on the posterior likelihood using the \pkg{loo} package.
}
\details{
When comparing models fitted to the same data, 
 the smaller the WAIC, the better the fit.
 For \code{brmsfit} objects, \code{waic} is an alias of \code{WAIC}.
}
\section{Methods (by class)}{
\itemize{
\item \code{brmsfit}: \code{WAIC} method for \code{brmsfit} objects
}}

\examples{
\dontrun{
# model with population-level effects only
fit1 <- brm(rating ~ treat + period + carry,
            data = inhaler, family = "gaussian")
WAIC(fit1)

# model with an additional varying intercept for subjects
fit2 <- brm(rating ~ treat + period + carry + (1|subject),
            data = inhaler, family = "gaussian")
# compare both models
WAIC(fit1, fit2)                          
}

}
\references{
Vehtari, A., Gelman, A., & Gabry J. (2016). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC. In Statistics 
and Computing, doi:10.1007/s11222-016-9696-4. arXiv preprint arXiv:1507.04544.

Gelman, A., Hwang, J., & Vehtari, A. (2014). 
Understanding predictive information criteria for Bayesian models. 
Statistics and Computing, 24, 997-1016.

Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation 
and widely applicable information criterion in singular learning theory. 
The Journal of Machine Learning Research, 11, 3571-3594.
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
