% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R, R/plots.R
\name{marginal_effects.brmsfit}
\alias{marginal_effects}
\alias{marginal_effects.brmsfit}
\alias{plot.brmsMarginalEffects}
\title{Display marginal effects of predictors}
\usage{
\method{marginal_effects}{brmsfit}(x, effects = NULL, conditions = NULL,
  re_formula = NA, robust = TRUE, probs = c(0.025, 0.975),
  method = c("fitted", "predict"), surface = FALSE, resolution = 100,
  too_far = 0, ...)

marginal_effects(x, ...)

\method{plot}{brmsMarginalEffects}(x, ncol = NULL, points = FALSE,
  rug = FALSE, stype = c("contour", "raster"),
  theme = bayesplot::theme_default(), ask = TRUE, plot = TRUE, ...)
}
\arguments{
\item{x}{An object usually of class \code{brmsfit}.}

\item{effects}{An optional character vector naming effects
(main effects or interactions) for which to compute marginal plots.
Interactions are specified by a \code{:} between variable names.
If \code{NULL} (the default), plots are generated for all main effects
and two-way interactions estimated in the model. When specifying
\code{effects} manually, \emph{all} two-way interactions may be plotted
even if not orginally modeled.}

\item{conditions}{An optional \code{data.frame} containing variable values
to condition on. Each effect defined in \code{effects} will
be plotted separately for each row of \code{data}. 
The row names of \code{data} will be treated as titles of the subplots. 
It is recommended to only define a few rows in order to keep the plots clear.
If \code{NULL} (the default), numeric variables will be marginalized
by using their means and factors will get their reference level assigned.}

\item{re_formula}{A formula containing random effects to be considered 
in the marginal predictions. If \code{NULL}, include all random effects; 
if \code{NA} (default), include no random effects.}

\item{robust}{If \code{TRUE} (the default) the median is used as the 
measure of central tendency. If \code{FALSE} the mean is used instead.}

\item{probs}{The quantiles to be used in the computation of credible
intervals (defaults to 2.5 and 97.5 percent quantiles)}

\item{method}{Either \code{"fitted"} or \code{"predict"}. 
If \code{"fitted"}, plot marginal predictions of the regression curve. 
If \code{"predict"}, plot marginal predictions of the responses.}

\item{surface}{Logical; Indicates whether interactions or 
two-dimensional smooths should be visualized as a surface. 
Defaults to \code{FALSE}. The surface type can be controlled 
via argument \code{stype} of the related plotting method.}

\item{resolution}{Number of support points used to generate 
the plots. Higher resolution leads to smoother plots. 
Defaults to \code{100}. If \code{surface} is \code{TRUE},
this implies \code{10000} support points for interaction terms,
so it might be necessary to reduce \code{resolution} 
when only few RAM is available.}

\item{too_far}{For surface plots only: Grid points that are too 
far away from the actual data points can be excluded from the plot. 
\code{too_far} determines what is too far. The grid is scaled into 
the unit square and then grid points more than \code{too_far} 
from the predictor variables are excluded. By default, all
grid points are used. Ignored for non-surface plots.}

\item{...}{Currently ignored.}

\item{ncol}{Number of plots to display per column for each effect.
If \code{NULL} (default), \code{ncol} is computed internally based
on the number of rows of \code{data}.}

\item{points}{Logical; indicating whether the original data points
should be added via \code{\link[ggplot2:geom_point]{geom_point}}.
Default is \code{FALSE}. Note that only those data points will be added
that match the specified conditions defined in \code{conditions}.}

\item{rug}{Logical; indicating whether a rug representation of predictor
values should be added via \code{\link[ggplot2:geom_rug]{geom_rug}}.
Default is \code{FALSE}.}

\item{stype}{Indicates how surface plots should be displayed.
Either \code{"contour"} or \code{"raster"}.}

\item{theme}{A \code{\link[ggplot2:theme]{theme}} object 
modifying the appearance of the plots. 
For some basic themes see \code{\link[ggplot2:ggtheme]{ggtheme}}
and \code{\link[bayesplot:theme_default]{theme_default}}.}

\item{ask}{logical; indicates if the user is prompted 
before a new page is plotted. 
Only used if \code{plot} is \code{TRUE}.}

\item{plot}{logical; indicates if plots should be
plotted directly in the active graphic device.
Defaults to \code{TRUE}.}
}
\value{
An object of class \code{brmsMarginalEffects}, which is a named list
  with one data.frame per effect containing all information required 
  to generate marginal effects plots. Among others, these data.frames
  contain some special variables, namely \code{estimate__} (predicted values
  of the response), \code{se__} (standard error of the predicted response),
  \code{lower__} and \code{upper__} (lower and upper bounds of the uncertainty
  interval of the response), as well as \code{cond__} (used in faceting when 
  \code{conditions} contains multiple rows).
  
  The corresponding \code{plot} method returns a named 
  list of \code{\link[ggplot2:ggplot]{ggplot}} objects, which can be further 
  customized using the \pkg{ggplot2} package.
}
\description{
Display marginal effects of one or more numeric and/or categorical 
predictors including two-way interaction effects.
}
\details{
When creating \code{marginal_effects} for a particular predictor 
  (or interaction of two predictors), one has to choose the values of all 
  other predictors to condition on. 
  By default, the mean is used for continuous variables
  and the reference category is used for factors, but you may change these
  values via argument \code{conditions}. 
  This also has an implication for the \code{points} argument: 
  In the created plots, only those points will be shown that correspond 
  to the factor levels actually used in the conditioning, in order not 
  to create the false impressivion of bad model fit, where it is just 
  due to conditioning on certain factor levels.
  Since we condition on rather than actually marginalizing variables, 
  the name  \code{marginal_effects} is possibly not ideally chosen in 
  retrospect. 

  \code{NA} values within factors in \code{conditions}, 
  are interpreted as if all dummy variables of this factor are 
  zero. This allows, for instance, to make predictions of the grand mean 
  when using sum coding.
}
\examples{
\dontrun{
fit <- brm(count ~ log_Age_c + log_Base4_c * Trt_c + (1 | patient),
           data = epilepsy, family = poisson()) 
           
## plot all marginal effects
plot(marginal_effects(fit), ask = FALSE)

## only plot the marginal interaction effect of 'log_Base4_c:Trt_c'
## for different values for 'log_Age_c'
conditions <- data.frame(log_Age_c = c(-0.3, 0, 0.3))
plot(marginal_effects(fit, effects = "log_Base4_c:Trt_c", 
                      conditions = conditions))
                      
## also incorporate random effects variance over patients
## also add data points and a rug representation of predictor values
plot(marginal_effects(fit, effects = "log_Base4_c:Trt_c", 
                      conditions = conditions, re_formula = NULL), 
     points = TRUE, rug = TRUE)
     
## fit a model to illustrate how to plot 3-way interactions
fit3way <- brm(count ~ log_Age_c * log_Base4_c * Trt_c, data = epilepsy)
conditions <- data.frame(log_Age_c = c(-0.3, 0, 0.3))
rownames(conditions) <- paste("log_Age_c =", conditions$log_Age_c)
plot(marginal_effects(fit3way, "log_Base4_c:Trt_c",
                      conditions = conditions))
}

}

