% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{kfold.brmsfit}
\alias{kfold.brmsfit}
\alias{kfold}
\title{K-Fold Cross-Validation}
\usage{
\method{kfold}{brmsfit}(x, ..., compare = TRUE, K = 10, newdata = NULL,
  save_fits = FALSE, update_args = list())

kfold(x, ...)
}
\arguments{
\item{x}{A fitted model object typically of class \code{brmsfit}.}

\item{...}{Optionally more fitted model objects.}

\item{compare}{A flag indicating if the information criteria
of the models should be compared to each other
via \code{\link[brms:compare_ic]{compare_ic}}.}

\item{K}{For \code{kfold}, the number of subsets of equal (if possible) size
into which the data will be randomly partitioned for performing
\eqn{K}-fold cross-validation. The model is refit \code{K} times, each time
leaving out one of the \code{K} subsets. If \code{K} is equal to the total
number of observations in the data then \eqn{K}-fold cross-validation is
equivalent to exact leave-one-out cross-validation.}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the orginal data of the model is used.}

\item{save_fits}{If \code{TRUE}, a component \code{fits} is added to 
the returned object to store the cross-validated \code{brmsfit} 
objects and the indices of the omitted observations for each fold. 
Defaults to \code{FALSE}.}

\item{update_args}{A \code{list} of further arguments passed to 
\code{\link[brms:update.brmsfit]{update.brmsfit}} such
as \code{iter}, \code{chains}, or \code{cores}.}
}
\value{
\code{kfold} returns an object that has a similar structure as the 
  objects returned by the \code{loo} and \code{waic} methods.
}
\description{
Perform exact K-fold cross-validation by refitting the model \eqn{K}
times each leaving out one-\eqn{K}th of the original data.
}
\details{
The \code{kfold} function performs exact \eqn{K}-fold
  cross-validation. First the data are randomly partitioned into \eqn{K}
  subsets of equal (or as close to equal as possible) size. Then the model is
  refit \eqn{K} times, each time leaving out one of the \code{K} subsets. If
  \eqn{K} is equal to the total number of observations in the data then
  \eqn{K}-fold cross-validation is equivalent to exact leave-one-out
  cross-validation (to which \code{loo} is an efficient approximation). The
  \code{compare_ic} function is also compatible with the objects returned
  by \code{kfold}.
}
\section{Methods (by class)}{
\itemize{
\item \code{brmsfit}: \code{kfold} method for \code{brmsfit} objects
}}

\examples{
\dontrun{
fit1 <- brm(count ~ log_Age_c + log_Base4_c * Trt + 
              (1|patient) + (1|obs),
           data = epilepsy, family = poisson())
# throws warning about some pareto k estimates being too high
(loo1 <- loo(fit1))
# perform 10-fold cross validation
(kfold1 <- kfold(fit1, chains = 2, cores = 2))
}   
 
}
\seealso{
\code{\link[brms:loo]{loo}}, \code{\link[brms:reloo]{reloo}}
}
