% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_model.R
\name{brm_model}
\alias{brm_model}
\title{Basic MMRM}
\usage{
brm_model(data, formula = brms.mmrm::brm_formula(), prior = NULL, ...)
}
\arguments{
\item{data}{A tidy data frame with one row per patient per discrete
time point.}

\item{formula}{An object of class \code{"brmsformula"} from \code{\link[=brm_formula]{brm_formula()}}
or \code{brms::brmsformula()}. Should include the full parameterization
of the model, including fixed effects, residual correlation,
and heterogeneity in the discrete-time-specific residual variance
components.}

\item{prior}{Either \code{NULL} for default priors
or a \code{"brmsprior"} object from \code{brms::prior()}.}

\item{...}{Arguments to \code{brms::brm()} other than \code{data}, \code{formula},
and \code{prior}.}
}
\value{
A fitted model object from \code{brms}.
}
\description{
Fit a basic MMRM model using \code{brms}.
}
\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_data(
  data = brm_simulate()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient"
)
formula <- brm_formula(
  data = data,
  effect_base = FALSE,
  interaction_base = FALSE
)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      model <- brm_model(
        data = data,
        formula = formula,
        chains = 1,
        iter = 100,
        refresh = 0
      )
    )
  )
)
model
brms::prior_summary(model)
}
}
\seealso{
Other models: 
\code{\link{brm_formula}()}
}
\concept{models}
