% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pollen_data.R
\name{create_pollen_sources}
\alias{create_pollen_sources}
\alias{create.pollen.sources}
\title{Pollen sources emission simulation}
\usage{
create_pollen_sources(
  sf,
  timeline = 1:61,
  density = runif(1, 7, 11),
  pollen = rgamma(1, shape = 1.6, scale = 1/(2 * 10^-7))
)

create.pollen.sources()
}
\arguments{
\item{sf}{A \link[sf]{sf} object defining sources fields}

\item{timeline}{Vector of interger. Time units (e.g. days) including the pollen emission 
(for simulation, default is time.max). Minimal value is a vector of 12 days.}

\item{density}{Plant density (number of plant by squared meter)}

\item{pollen}{Pollen production (number of grains by plant)}
}
\value{
A matrix indexed by sources ID (in rows) and by time ( in columns) whose rows give 
the values of pollen emission (number of grains) for every source.
}
\description{
Simulate pollen sources emission for maize crop. The proportion of plants
emitting pollen per day (during 12 days) was observed by Frédérique Angevin (Angevin et al. 2008).
}
