% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/richness_wlrm_t.R
\name{wlrm_transformed}
\alias{wlrm_transformed}
\title{The transformed weighted linear regression estimator for species richness estimation}
\usage{
wlrm_transformed(
  input_data,
  cutoff = NA,
  print = NULL,
  plot = NULL,
  answers = NULL
)
}
\arguments{
\item{input_data}{An input type that can be processed by \code{convert()} or a \code{phyloseq} object}

\item{cutoff}{Maximum frequency count to use}

\item{print}{Deprecated; only for backwards compatibility}

\item{plot}{Deprecated; only for backwards compatibility}

\item{answers}{Deprecated; only for backwards compatibility}
}
\value{
An object of class \code{alpha_estimate}, or \code{alpha_estimates} for \code{phyloseq} objects
}
\description{
This function implements the transformed version of the species richness
estimation procedure outlined in Rocchetti, Bunge and Bohning (2011).
}
\note{
While robust to many different structures, model is almost always
misspecified. The result is usually implausible diversity estimates with
artificially low standard errors. Extreme caution is advised.
}
\examples{

wlrm_transformed(apples)
wlrm_transformed(apples, plot = FALSE, print = FALSE, answers = TRUE)

}
\references{
Rocchetti, I., Bunge, J. and Bohning, D. (2011). Population size
estimation based upon ratios of recapture probabilities. \emph{Annals of
Applied Statistics}, \bold{5}.
}
\seealso{
\code{\link{breakaway}}; \code{\link{apples}};
\code{\link{wlrm_untransformed}}
}
\author{
Amy Willis
}
\keyword{diversity}
\keyword{models}
