% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{AAL}
\alias{AAL}
\alias{aal116}
\alias{aal90}
\alias{aal2.120}
\alias{aal2.94}
\title{Coordinates for data from the AAL-based atlases}
\format{A data frame with 90 or 116 (for the original AAL atlases), or 94 or
120 (for the newer AAL2 atlases) observations on the following 7 variables:
\describe{
  \item{\code{name}}{a character vector of region names}
  \item{\code{x.mni}}{a numeric vector of x-coordinates (in MNI space)}
  \item{\code{y.mni}}{a numeric vector of y-coordinates (in MNI space)}
  \item{\code{z.mni}}{a numeric vector of z-coordinates (in MNI space)}
  \item{\code{lobe}}{a factor with levels \code{Frontal} \code{Parietal}
    \code{Temporal} \code{Occipital} \code{Insula} \code{Limbic} \code{SCGM}
    and \code{Cerebellum} (for \code{aal116} and \code{aal2.120})}
  \item{\code{hemi}}{a factor with levels \code{L} \code{R}}
  \item{\code{index}}{a numeric vector}
}}
\usage{
aal116

aal90

aal2.120

aal2.94
}
\description{
Datasets containing spatial coordinates for the original AAL atlases and the
newer AAL2 atlases, along with indices for the major lobes and hemispheres of
the brain.
}
\references{
Tzourio-Mazoyer N., Landeau B., Papathanassiou D., Crivello F.,
  Etard O., Delcroix N., Mazoyer B., Joliot M. (2002) \emph{Automated
  anatomical labeling of activations in SPM using a macroscopic anatomical
  parcellation of the MNI MRI single-subject brain}. NeuroImage,
  15(1):273-289.

Rolls E.T., Joliot M., Tzourio-Mazoyer N. (2015)
  \emph{Implementation of a new parcellation of the orbitofrontal cortex in
  the automated anatomical labelling atlas}. NeuroImage, 122:1-5.
}
\keyword{datasets}
