% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_GLM.R
\name{GLM fits}
\alias{GLM fits}
\alias{brainGraph_GLM_fit_t}
\alias{brainGraph_GLM_fit_f}
\title{Fit linear models for t and F contrasts}
\usage{
brainGraph_GLM_fit_t(X, y, XtX, contrast)

brainGraph_GLM_fit_f(X, y, dfR, contrast, rkC, CXtX)
}
\arguments{
\item{X}{Numeric matrix, if you wish to supply your own design matrix}

\item{y}{Numeric vector; the outcome variable}

\item{XtX}{Numeric matrix}

\item{contrast}{A numeric matrix (1 row) for a single contrast}

\item{dfR}{Integer; residual degrees of freedom}

\item{rkC}{Integer; rank of the contrast matrix}

\item{CXtX}{Numeric matrix}
}
\value{
\code{brainGraph_GLM_fit_t} - A list containing:
  \item{gamma}{The contrast of parameter estimates}
  \item{se}{The standard error}

\code{brainGraph_GLM_fit_f} - A list containing:
  \item{numer}{The extra sum of squares due to the full model divided by the
    rank of the contrast matrix}
  \item{se}{The sum of squared errors of the full model}
  \item{contrast}{The contrast number; defaults to \code{1}}
}
\description{
\code{brainGraph_GLM_fit_t} fits a linear model for t-contrasts (i.e.,
uni-dimensional contrasts) and returns the contrasts of parameter estimates,
standard errors, t-statistics, and P-values. If a contrast matrix is
supplied, it will return the above values for each row of the matrix.

\code{brainGraph_GLM_fit_f} fits a linear model for F contrasts (i.e.,
multi-dimensional contrasts) and returns the \emph{extra sum of squares} due
to the full model, the sum of squared errors of the full model, the
F-statistic, and associated P-value.
}
\details{
For speed purposes (if it is called from \code{\link{brainGraph_GLM}} and
permutation testing is done), this function does not do argument checking.
}
\seealso{
Other GLM functions: \code{\link{GLM design}},
  \code{\link{GLM}}, \code{\link{mtpc}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{GLM functions}
