% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{logMargLikelihood_or2}
\alias{logMargLikelihood_or2}
\title{Marginal likelihood for ordinal quantile model
with 3 outcomes}
\usage{
logMargLikelihood_or2(y, x, b0, B0, n0, d0, postMeanbeta, postMeansigma,
btildeStore, BtildeStore, gamma, p)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{b0}{prior mean for normal distribution to sample \eqn{\beta}.}

\item{B0}{prior variance for normal distribution to sample \eqn{\beta}}

\item{n0}{prior for shape parameter to sample \eqn{\sigma} from inverse gamma distribution.}

\item{d0}{prior for scale parameter to sample \eqn{\sigma} from inverse gamma distribution.}

\item{postMeanbeta}{a vector with mean of sampled \eqn{\beta} for each covariate.}

\item{postMeansigma}{a vector with mean of sampled \eqn{\sigma}.}

\item{btildeStore}{a storage matrix for posterior mean of \eqn{\beta}.}

\item{BtildeStore}{a storage matrix for posterior variance of \eqn{\beta}.}

\item{gamma}{one and only cut-point other than 0.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a scalar for logarithm of marginal likelihood
}
\description{
This function computes the logarithm of marginal likelihood for ordinal
quantile model with 3 outcomes using Gibbs output from the
complete and reduced runs.
}
\details{
Function computes the logarithm of marginal likelihood for
ordinal model with 3 outcomes using a Gibbs sampling
procedure.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
k <- dim(x)[2]
output <- quantreg_or2(y = y, x = x, B0 = 10*diag(k),
mcmc = 50, p = 0.25, display = FALSE)
# output$logMargLikelihood
#   -404.57

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Chib, S. (1995). “Marginal likelihood from the Gibbs output.” Journal of the American
Statistical Association, 90(432):1313–1321, 1995. DOI: 10.1080/01621459.1995.10476635

Greenberg, E. (2012). “Introduction to Bayesian Econometrics.” Cambridge University
Press, Cambridge. DOI: 10.1017/CBO9780511808920
}
\seealso{
\link[invgamma]{dinvgamma}, \link[NPflow]{mvnpdf}, \link[stats]{dnorm},
Gibbs sampling
}
