% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{drawlatentg3}
\alias{drawlatentg3}
\title{Samples the Latent Variable z for an Ordinal Models
with more than 3 outcomes}
\usage{
drawlatentg3(y, x, beta, w, theta, tau2, delta)
}
\arguments{
\item{y}{dependent variable i.e. ordinal outcome values.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{beta}{Gibbs draw of coeffcients of dimension \eqn{(k x 1)}.}

\item{w}{latent weights vector.}

\item{theta}{(1-2p)/(p(1-p)).}

\item{tau2}{2/(p(1-p)).}

\item{delta}{row vector of cutpoints including -Inf and Inf.}
}
\value{
Returns a column vector of values for latent variable, z.
}
\description{
This function samples the latent variable z from a truncated
normal distribution for an ordinal model with more than 3 outcomes.
}
\details{
Function samples the latent variable z from a truncated normal
distribution.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
p <- 0.25
beta <- c(-1.429465, 1.135585, 2.107666)
w <- 1.114347
theta <- 2.666667
tau2 <- 10.66667
delta <- c(-0.9026915, -2.2488833)
ans <- drawlatentg3(y, x, beta, w, theta, tau2, delta)

# ans
#   0.9812363 -1.09788 -0.9650175 8.396556
#   1.39465 -0.8711435 -0.5836833 -2.792464
#   0.1540086 -2.590724 0.06169976 -1.823058
#   0.06559151 0.1612763 0.161311 4.908488
#   0.6512113 0.1560708 -0.883636 -0.5531435 ... soon

}
\references{
Albert, J. and Chib, S. (1993). “Bayesian Analysis of Binary and Polychotomous
Response Data.” Journal of the American Statistical Association, 88(422): 669–679.

Casella, G., George E. I. (1992). “Explaining the Gibbs Sampler."
The American Statistician, 46(3): 167-174.

Geman, S., and Geman, D. (1984). “Stochastic Relaxation,
Gibbs Distributions, and the Bayesian Restoration of Images."
IEEE Transactions an Pattern Analysis and Machine Intelligence,
6(6): 721-741.
}
\seealso{
Gibbs sampling, truncated normal distribution,
\link[truncnorm]{rtruncnorm}
}
