% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{predict.bpnme}
\alias{predict.bpnme}
\title{Predicted values for a Bayesian circular mixed-effects model}
\usage{
\method{predict}{bpnme}(object, ...)
}
\arguments{
\item{object}{a \code{bpnme object} obtained from the function
\code{\link{bpnme}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a matrix (rows = N, columns = iterations) containing predicted values
  for the circular outcome for each iteration of the MCMC sampler.
}
\description{
Outputs predicted values for a Bayesian circular mixed-effects model for each
iteration of the MCMC sampler.
}
\examples{
library(bpnreg)
fit.Motor <- bpnr(pred.I = Phaserad ~ 1 + Cond, data = Motor,
its = 100, burn = 10, n.lag = 3)
predict(fit.Motor)

}
