% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_delete_restore.R
\name{box_delete_file}
\alias{box_delete_file}
\alias{box_delete_folder}
\alias{box_restore_file}
\alias{box_restore_folder}
\title{Move files to and from the box.com trash folder}
\usage{
box_delete_file(file_id)

box_delete_folder(dir_id)

box_restore_folder(dir_id)

box_restore_file(file_id)
}
\arguments{
\item{file_id}{The box.com id for the file that you'd like delete/restore}

\item{dir_id}{The box.com id for the folder that you'd like delete/restore}
}
\value{
An object of class 
  \code{\link[=boxr_S3_classes]{boxr_file_reference}}.
}
\description{
\itemize{
  \item \code{box_delete_file} moves a file to the trash folder.
  \item \code{box_delete_folder} moves a whole folder (and all of it's 
    contents) to the trash folder.
  \item \code{box_restore_file} moves a file from the trash, to wherever it 
    was before
  \item \code{box_delete_folder} does the same thing for a folder.
}
}
\details{
'Deleting' a file in this case means moving it to a special folder
  within your box.com account called the 'Trash'. At the time of writing,
  the files are stored for three months before being deleted, and the 
  contents of the folder can be accessed from the top right hand menu of the 
  web interface.
}
\author{
Brendan Rocks \email{foss@brendanrocks.com}
}
\seealso{
\code{\link{box_ul}}, for putting files there in the first place
}

