% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.r
\name{file}
\alias{file}
\title{Find the full file names of files in modules}
\usage{
file(..., module = current_mod())
}
\arguments{
\item{...}{character vectors of files or subdirectories inside a module; if
none is given, return the root directory of the module}

\item{module}{a module environment (default: current module)}
}
\value{
A character vector containing the absolute paths to the files
 specified in \code{...}.
}
\description{
Find the full file names of files in modules
}
\note{
If called from outside a module, the current working directory is used.

This function is similar to \code{system.file} for packages. Its semantics
differ in the presence of non-existent files: \code{box::file} always returns
the requested paths, even for non-existent files; whereas \code{system.file}
returns empty strings for non-existent files, or fails (if requested via the
argument \code{mustWork = TRUE}).
}
\seealso{
\code{\link[base]{system.file}}
}
