% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/vastol.R
\name{vastol}
\alias{vastol}
\title{Bootstrap Alternative to Vasicek Test.}
\usage{
vastol(segment, target, bootsamp, grp, alpha, lower)
}
\arguments{
\item{segment}{- The score groupings.}

\item{target}{- The binary target variable.}

\item{bootsamp}{- How many bootstrap samples to be computed. When bootsamp is too low, a warning will be produced.}

\item{grp}{- An integer value of how the segments are grouped.}

\item{alpha}{- Confidence level.}

\item{lower}{- Set equal to 1 if calculating a lower bound.}
}
\description{
Creates 100(1-alpha) percent bootstrap percentile confidence intervals as an alternative to the Vasicek test.
}
\examples{
data("vasdata")
vas.level=vastol(segment=vasdata$segment,target=vasdata$response
,bootsamp=500,grp=10,alpha=0.99,lower=1)
}
\references{
[1] Glennon, D., ``Managing Model Risk in Retail Scoring," Credit Risk Analysis Division Office of the Comptroller of the Currency, September 2012.
}

