% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_of_integration.R
\name{plot_missing_values}
\alias{plot_missing_values}
\title{Plot Missing Values}
\usage{
plot_missing_values(y, show_names = FALSE, show_legend = TRUE,
  axis_text_size = NULL, legend_size = NULL, cols = NULL)
}
\arguments{
\item{y}{A (\eqn{T}x\eqn{N})-matrix of \eqn{N} time series with \eqn{T} observations. Data may also be in a time series format (e.g. \code{ts}, \code{zoo} or \code{xts}) or data frame.}

\item{show_names}{Show the time series' names on the plot (\code{TRUE}) or not (\code{FALSE}). Default is \code{TRUE}.}

\item{show_legend}{Logical indicator whether a legend should be displayed. Default is \code{TRUE}.}

\item{axis_text_size}{Size of the text on the axis. Default takes \code{ggplot2} defaults.}

\item{legend_size}{Size of the text in the legend if \code{show_legend = TRUE}. Default takes \code{ggplot2} defaults.}

\item{cols}{Vector with colours for displaying the different types of data. If the default is overwritten, four colours must be supplied.}
}
\value{
A \code{ggplot2} object containing the missing values plot.
}
\description{
Plots missing values of different types for a time series dataset.
}
\details{
The function distinguish four types of data: observed data (non-missing) and three missing types. Type \code{"Balanced NA"} indicates where entire rows are missing (\code{NA}). These do not cause unbalancedness as the missing rows can simply be deleted.  Type \code{"Unalanced NA"} are missing values on the beginning or end of the sample, which cause unbalancedness. These affect some (but not all) bootstrap methods, see e.g.~\code{\link{bFDRtest}}. Type \code{"Internal NA"} are missing values inside the sample, which need to be removed before the bootstrap unit root tests can be used.

This function requires the package \code{ggplot2} to be installed. If the package is not found, plotting is aborted.
}
