% Generated by roxygen2 (4.0.0): do not edit by hand
\name{defaultOOBPerformanceAnalysis}
\alias{defaultOOBPerformanceAnalysis}
\title{Perform generic out-of-bag error analysis.}
\usage{
defaultOOBPerformanceAnalysis(prediction, response, oobObs)
}
\arguments{
\item{prediction}{a vector of predicted responses.}

\item{response}{a vector of true response.}

\item{oobObs}{a vector of indices which values in \code{predictions} are of
out-of-bag observations.}
}
\value{
If performing regression, return a list with components:
\item{oobMSE}{the out-of-bag mean squared error.}
\item{resVec}{a vector of length \code{nrow(data)} whose entries correspond to
observations in \code{data}. The entry has values \code{NA} if the observation
was not out-of-bag, and the difference between the predicted and true response
(the residual) if the observation was out-of-bag.}

Otherwise, return a list with components:
\item{oobErr}{overall misclassification rate.}
\item{oobConfMat}{the confusion matrix of out-of-bag predictions against the
true class labels.}
\item{errVec}{a vector of length \code{nrow(data)} whose entries correspond to
observations in \code{data}. The entry has values \code{NA} if the observation
was not out-of-bag, and a 1 or 0 depending whether \code{estimator} failed to
correctly classify the observation.}
}
\description{
If performing regression, calculate which out-of-bag residuals and MSE.
Otherwise, calculate which out-of-bag observations were classified correctly,
what the overall misclassification rate is, as well as the confusion matrix.
}
\seealso{
Other performance analyzers: \code{\link{boost}},
  \code{\link{boost.function}}, \code{\link{boost.list}}
}

