% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomials.R
\name{hermite_polynomials}
\alias{hermite_polynomials}
\alias{hermite}
\alias{hermite_next}
\title{Hermite Polynomials and Related Functions}
\usage{
hermite(n, x)

hermite_next(n, x, Hn, Hnm1)
}
\arguments{
\item{n}{Degree of the polynomial}

\item{x}{Argument of the polynomial}

\item{Hn}{Value of the Hermite polynomial \eqn{(H_n(x))}}

\item{Hnm1}{Value of the Hermite polynomial \eqn{(H_{n-1}(x))}}
}
\value{
A single numeric value with the computed Hermite polynomial or its next value.
}
\description{
Functions to compute Hermite polynomials.
}
\examples{
# Hermite polynomial H_2(0.5)
hermite(2, 0.5)
# Next Hermite polynomial H_3(0.5) using H_2(0.5) and H_1(0.5)
hermite_next(2, 0.5, hermite(2, 0.5), hermite(1, 0.5))
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/sf_poly/hermite.html}{Boost Documentation} for more details on the mathematical background.
}
