% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{cubic_hermite}
\alias{cubic_hermite}
\title{Cubic Hermite Interpolator}
\usage{
cubic_hermite(x, y, dydx)
}
\arguments{
\item{x}{Numeric vector of abscissas (x-coordinates).}

\item{y}{Numeric vector of ordinates (y-coordinates).}

\item{dydx}{Numeric vector of derivatives (slopes) at each point.}
}
\value{
An object of class \code{cubic_hermite} with methods:
\itemize{
\item \code{interpolate(xi)}: Evaluate the interpolator at point \code{xi}.
\item \code{prime(xi)}: Evaluate the derivative of the interpolator at point \code{xi}.
\item \code{push_back(x, y, dydx)}: Add a new control point to the interpolator.
\item \code{domain()}: Get the domain of the interpolator.
}
}
\description{
Constructs a cubic Hermite interpolator given the vectors of abscissas, ordinates, and derivatives.
}
\examples{
x <- c(0, 1, 2)
y <- c(0, 1, 0)
dydx <- c(1, 0, -1)
interpolator <- cubic_hermite(x, y, dydx)
xi <- 0.5
interpolator$interpolate(xi)
interpolator$prime(xi)
interpolator$push_back(3, 0, 1)
interpolator$domain()
}
