% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial_distribution.R
\name{binomial_distribution}
\alias{binomial_distribution}
\alias{binomial_pdf}
\alias{binomial_lpdf}
\alias{binomial_cdf}
\alias{binomial_lcdf}
\alias{binomial_quantile}
\alias{binomial_find_lower_bound_on_p}
\alias{binomial_find_upper_bound_on_p}
\alias{binomial_find_minimum_number_of_trials}
\alias{binomial_find_maximum_number_of_trials}
\title{Binomial Distribution Functions}
\usage{
binomial_distribution(n, prob)

binomial_pdf(k, n, prob)

binomial_lpdf(k, n, prob)

binomial_cdf(k, n, prob)

binomial_lcdf(k, n, prob)

binomial_quantile(p, n, prob)

binomial_find_lower_bound_on_p(n, k, alpha, method = "clopper_pearson_exact")

binomial_find_upper_bound_on_p(n, k, alpha, method = "clopper_pearson_exact")

binomial_find_minimum_number_of_trials(k, prob, alpha)

binomial_find_maximum_number_of_trials(k, prob, alpha)
}
\arguments{
\item{n}{number of trials (n >= 0)}

\item{prob}{probability of success on each trial (0 <= prob <= 1)}

\item{k}{number of successes (0 <= k <= n)}

\item{p}{probability (0 <= p <= 1)}

\item{alpha}{Largest acceptable probability that the true value of the success fraction is less than the value returned (by \code{binomial_find_lower_bound_on_p}) or greater than the value returned (by \code{binomial_find_upper_bound_on_p}).}

\item{method}{Method to use for calculating the confidence bounds. Options are "clopper_pearson_exact" (default) and "jeffreys_prior".}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Binomial distribution.
}
\examples{
# Binomial distribution with n = 10, prob = 0.5
dist <- binomial_distribution(10, 0.5)
# Apply generic functions
cdf(dist, 2)
logcdf(dist, 2)
pdf(dist, 2)
logpdf(dist, 2)
hazard(dist, 2)
chf(dist, 2)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
binomial_pdf(3, 10, 0.5)
binomial_lpdf(3, 10, 0.5)
binomial_cdf(3, 10, 0.5)
binomial_lcdf(3, 10, 0.5)
binomial_quantile(0.5, 10, 0.5)

\dontrun{
# Find lower bound on p given k = 3 successes in n = 10 trials with 95\% confidence
binomial_find_lower_bound_on_p(10, 3, 0.05)
# Find upper bound on p given k = 3 successes in n = 10 trials with 95\% confidence
binomial_find_upper_bound_on_p(10, 3, 0.05)
# Find minimum number of trials n to observe k = 3 successes with p = 0.5 at 95\% confidence
binomial_find_minimum_number_of_trials(3, 0.5, 0.05)
# Find maximum number of trials n to observe k = 3 successes with p = 0.5 at 95\% confidence
binomial_find_maximum_number_of_trials(3, 0.5, 0.05)
}
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/binomial_dist.html}{Boost Documentation} for more details on the mathematical background.
}
