% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weather_bulletins.R
\name{get_weather_bulletin}
\alias{get_weather_bulletin}
\title{Get BOM 0900 or 1500 weather bulletin}
\usage{
get_weather_bulletin(state = "qld", morning = TRUE)
}
\arguments{
\item{state}{Australian state or territory as full name or postal code.
Fuzzy string matching via \code{\link[base]{agrep}} is done.}

\item{morning}{If \code{TRUE}, return the 9am bulletin for the nominated
state; otherwise return the 3pm bulletin.}
}
\value{
Data frame as a \code{\link[data.table]{data.table}} object of Australian 9am
or 3pm weather observations for a state.  For full details of fields and
units returned see Appendix 4, "Appendix 4 - Output from
get_weather_bulletin()" in the \CRANpkg{bomrang} vignette, use \cr
\code{vignette("bomrang", package = "bomrang")} to view.
}
\description{
Fetch the daily \acronym{BOM} 0900 or 1500 weather bulletins and return a
data frame for a specified state or territory.
}
\details{
Allowed state and territory postal codes:
\describe{
\item{ACT}{Australian Capital Territory (will return NSW)}
\item{NSW}{New South Wales}
\item{NT}{Northern Territory}
\item{QLD}{Queensland}
\item{SA}{South Australia}
\item{TAS}{Tasmania}
\item{VIC}{Victoria}
\item{WA}{Western Australia}
}
It is not possible to return weather bulletins for the entire country in a
single call. Rainfall figures for the 9am bulletin are generally for the
preceding 24 hours, while those for the 3pm bulletin are for the preceding 6
hours since 9am. Note that values are manually entered into the bulletins and
sometimes contain typographical errors which may lead to warnings about
\code{"NAs introduced by coercion"}.
}
\examples{
\donttest{
qld_weather <- get_weather_bulletin(state = "QLD", morning = FALSE)
qld_weather
}
}
\references{
Daily observation data come from Australian Bureau of Meteorology (BOM)
website. The 3pm bulletin for Queensland is, for example, \cr
\url{http://www.bom.gov.au/qld/observations/3pm_bulletin.shtml}
}
\author{
Mark Padgham, \email{mark.padgham@email.com}
}
