% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_satellite_imagery.R
\name{get_satellite_imagery}
\alias{get_satellite_imagery}
\title{Get BOM Satellite GeoTIFF Imagery}
\usage{
get_satellite_imagery(product_id, scans = 1, cache = FALSE)
}
\arguments{
\item{product_id}{Character.  BOM product ID to download in GeoTIFF format
and import as a \code{\link[raster]{stack}} object.  A vector of values from
\code{\link{get_available_imagery}} may be used here.  Value is required.}

\item{scans}{Numeric.  Number of scans to download, starting with most recent
and progressing backwards, \emph{e.g.}, 1 - the most recent single scan
available , 6 - the most recent hour available, 12 - the most recent 2 hours
available, etc.  Negating will return the oldest files first.  Defaults to 1.
Value is optional.}

\item{cache}{Logical.  Store image files locally for later use?  If
\code{FALSE}, the downloaded files are removed when R session is closed. To
take advantage of cached files in future sessions, use \var{cache = TRUE}.
Defaults to \code{FALSE}.  Value is optional.}
}
\value{
A raster stack of GeoTIFF images with layers named by BOM Product ID,
timestamp and band.
}
\description{
Fetch BOM satellite GeoTIFF imagery from
\url{ftp://ftp.bom.gov.au/anon/gen/gms/} and return a raster
\code{\link[raster]{stack}} object of GeoTIFF files. Files are available at
ten minute update frequency with a 24 hour delete time. Suggested to check
file availability first by using \code{\link{get_available_imagery}}.
}
\details{
Valid BOM satellite Product IDs include:
\describe{
\item{IDE00420}{AHI cloud cover only 2km FD GEOS GIS}
\item{IDE00421}{AHI IR (Ch13) greyscale 2km FD GEOS GIS}
\item{IDE00422}{AHI VIS (Ch3) greyscale 2km FD GEOS GIS}
\item{IDE00423}{AHI IR (Ch13) Zehr 2km FD GEOS GIS}
\item{IDE00425}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 1km FD
 GEOS GIS}
\item{IDE00426}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 2km FD
 GEOS GIS}
\item{IDE00427}{AHI WV (Ch8) 2km FD GEOS GIS}
\item{IDE00430}{AHI cloud cover only 2km AUS equirect. GIS}
\item{IDE00431}{AHI IR (Ch13) greyscale 2km AUS equirect. GIS}
\item{IDE00432}{AHI VIS (Ch3) greyscale 2km AUS equirect. GIS}
\item{IDE00433}{AHI IR (Ch13) Zehr 2km AUS equirect. GIS}
\item{IDE00435}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 1km AUS
 equirect. GIS}
\item{IDE00436}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 2km AUS
 equirect. GIS}
\item{IDE00437}{AHI WV (Ch8) 2km AUS equirect. GIS}
\item{IDE00439}{AHI VIS (Ch3) greyscale 0.5km AUS equirect. GIS}
}

We cache using \pkg{hoardr}, find your cache folder by executing
\code{manage_cache$cache_path_get}.
}
\examples{
\dontrun{
# Fetch AHI VIS (true colour) / IR (Ch13 greyscale) composite 1km FD
# GEOS GIS raster stack for most recent single scan available

imagery <- get_satellite_imagery(product_id = "IDE00425", scans = 1)

# Get a list of available image files and use that to specify files for
# download, downloading the two most recent files available

avail <- get_available_imagery(product_id = "IDE00425")
imagery <- get_satellite_imagery(product_id = avail, scans = 2)

}
}
\references{
Australian Bureau of Meteorology (BOM) high-definition satellite images \cr
\url{http://www.bom.gov.au/australia/satellite/index.shtml}
}
\seealso{
\code{\link{get_available_imagery}}
\code{\link{manage_cache}}
}
\author{
Adam H Sparks, \email{adamhsparks@gmail.com}
}
