% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryNet.R
\name{queryNet}
\alias{queryNet}
\alias{queryNetParallel}
\title{Query the Bayesian network}
\usage{
queryNet(network, target, evidence, ...)

queryNetParallel(network, target, evidence, inparallel = TRUE, ...)
}
\arguments{
\item{network}{The Bayesian network. An object of class \code{grain}, or a character (the path to the \emph{.net} file to be loaded)}

\item{target}{character. The node of interest to be modelled and mapped.}

\item{evidence}{matrix or data.frame. Named columns are the known input variables; rows are the discrete states associated to them for each record (NA allowed).}

\item{...}{Additional arguments to force one or more nodes to a state (i.e. fixing evidence). If the node is 
associated to any input spatial data, the latter will be ignored, thus resulting spatially equal everywhere.
Node name must be provided as argument and the associated fixed state as 
character; both node and state names must be typed exactly as their names in the network.}

\item{inparallel}{logical or integer. Number of cores to be used by \code{queryNetParallel}. 
Default is TRUE, so the maximum number available minus one is set.}
}
\value{
A matrix of probabilities: columns are the states of the target node and rows are the probabilities 
associated to each record (i.e. spatial locations) from \code{evidence}.
}
\description{
This function queries the Bayesian network and returns the probabilities for each 
state of the target node. Available input variables are set as evidence.\cr 
\code{queryNetParallel} works as \code{queryNet}, but makes use of multi cores/processors facilities 
for big network queries, by splitting data into chunks and processing them in parallel.
}
\examples{
list2env(ConwyData, environment())

network <- LandUseChange

q <- queryNet(network, 'FinalLULC', evidence)
head(q)

## Fix a given node on a state (i.e. fixed evidence) by providing an additional argument
q <- queryNet(network, 'FinalLULC', evidence, Stakeholders = 'farmers')
head(q)

## Fix evidence for two nodes, including one of the spatial inputs (i.e. overriden by evidence)
q <- queryNet(network, 'FinalLULC', evidence, Stakeholders = 'farmers', CurrentLULC = 'forest')
head(q)
## For a programmatic approach, the arguments could be passed as named list:
# lst <- list(Stakeholders = 'farmers', CurrentLULC = 'forest')
# queryNet(network, 'FinalLULC', evidence, lst)

## Use parallel processing
q <- queryNetParallel(network, 'FinalLULC', evidence, inparallel=2)
head(q)

}
