## ---- message=FALSE, warning=FALSE, results='hide', fig.height=4, fig.width=6----
## Loading package and data stored in it
library(bnspatial)
data(ConwyData)
network <- LandUseChange
spatialData <- c(currentLU, slope, status)
lookup <- LUclasses
target <- 'FinalLULC'

## Run a spatial query on the Bayesian network 
## A summary will be printed on screen to check whether spatial data correspond 
## to network nodes as intended.
bn <- bnspatial(network, target, spatialData, lookup)
bn

## Plot output maps
library(raster)
par(mfrow=c(1,2))
plot(bn$Class, main='Most likely class')
plot(bn$Entropy, main='Uncertainty (Shannon index)')

## ---- message=FALSE, warning=FALSE, echo=FALSE---------------------------
bn <- bnspatial(network, 'FinalLULC', spatialData, lookup, verbose=FALSE)

## ---- message=FALSE, warning=FALSE, eval=FALSE---------------------------
#  ## Loading data stored in package
#  network <- 'fullPath/toPackageLibrary/bnspatial/extdata/LandUseChange.net'
#  
#  spatialData <- c('fullPath/toPackageLibrary/bnspatial/extdata/CurrentLULC.tif',
#                   'fullPath/toPackageLibrary/bnspatial/extdata/degSlope.tif',
#                   'fullPath/toPackageLibrary/bnspatial/extdata/LegalStatus.tif')
#  
#  lookup <- 'fullPath/toPackageLibrary/bnspatial/extdata/LUclasses.txt'
#  
#  ## Run a spatial query on the Bayesian network
#  bn <- bnspatial(network, 'FinalLULC', spatialData, lookup)

## ---- message=FALSE, warning=FALSE, results='hide', fig.height=4, fig.width=6----
bn <- bnspatial(network, 'FinalLULC', spatialData, lookup, msk=currentLU, 
                   what="probability", targetState=c("arable","forest"))
par(mfrow=c(1,2))
plot(bn$Probability$forest, main="Probability of forest")
plot(bn$Probability$arable, main="Probability of arable land")

## ---- message=FALSE, warning=FALSE, results='hide', fig.height=8, fig.width=6----
par(mfrow=c(2,2))

bn <- bnspatial(network, "RelativePreference", spatialData, lookup, msk=currentLU, 
                   Scenarios="intensification")
plot(bn$Class, main="Intensification scenario")
plot(bn$Entropy, main="Uncertainty (Shannon index)")

bn <- bnspatial(network, 'RelativePreference', spatialData, lookup, msk=currentLU, 
                   Scenarios="sustainable")
plot(bn$Class, main="Sustainability scenario")
plot(bn$Entropy, main="Uncertainty (Shannon index)")

## ---- message=FALSE, warning=FALSE, results='hide', fig.height=8, , fig.width=6, echo=-c(1:2)----
par(mfrow=c(2,2))

bn <- bnspatial(network, "RelativePreference", spatialData, lookup, msk=currentLU, 
                   what="probability", targetState=c("forest","arable"), Scenarios="intensification")
plot(bn$Probability$forest, main="P of forest preference (intensif.)")
plot(bn$Probability$arable, main="P of arable preference (intensif.)")

bn <- bnspatial(network, 'RelativePreference', spatialData, lookup, msk=currentLU, 
                   what="probability", targetState=c("forest","arable"), Scenarios="sustainable")
plot(bn$Probability$forest, main="P of forest preference (sustain.)")
plot(bn$Probability$arable, main="P of arable preference (sustain.)")

## ---- message=FALSE, warning=FALSE, results='hide', echo=-c(1:2), fig.height=8, fig.width=6----
par(mfrow=c(2,2))

midValues <- c(175, 75, 15)

bn <- bnspatial(network, "CarbonStock", spatialData, lookup, msk=currentLU, 
                   midvals=midValues, what=c("expected","variation"), Scenarios="intensification")
plot(bn$ExpectedValue, main="Expected carbon (t/ha) (intensif.)")
plot(bn$CoeffVariation, main="Uncertainty (coeff. variation)")

bn <- bnspatial(network, "CarbonStock", spatialData, lookup, msk=currentLU, 
                   midvals=midValues, what=c("expected","variation"), Scenarios="sustainable")
plot(bn$ExpectedValue, main="Expected carbon (t/ha) (sustain.)")
plot(bn$CoeffVariation, main="Uncertainty (coeff. variation)")

## ---- eval=FALSE---------------------------------------------------------
#  bn <- bnspatial(network, 'FinalLULC', spatialData, lookup, inparallel=2)

## ---- eval=FALSE---------------------------------------------------------
#  network <- loadNetwork(LandUseChange, target='FinalLULC')
#  network

## ---- eval=FALSE---------------------------------------------------------
#  fullpath <- system.file("extdata", "LUclasses.txt", package = "bnspatial")
#  fullpath
#  
#  intervals <- importClasses(fullpath)
#  intervals

## ---- eval=FALSE---------------------------------------------------------
#  spatialData <- c(currentLU, slope, status)
#  spatialDataList <- linkMultiple(spatialData, network, intervals)

## ---- eval=FALSE---------------------------------------------------------
#  ## Return coordinates of valid cells inside the mask instead of a raster layer
#  msk <- aoi(spatialData, xy=TRUE)
#  head(msk)

## ---- eval=FALSE---------------------------------------------------------
#  m <- aoi(msk=currentLU, mskSub=c(2,3))
#  head( extractByMask(slope, msk=m), 20)

## ---- eval=FALSE---------------------------------------------------------
#  s <- runif(30)
#  
#  ## Split by user defined values. Values out of boundaries are set to NA:
#  dataDiscretize(s, classBoundaries = c(0.2, 0.5, 0.8))

## ---- eval=FALSE---------------------------------------------------------
#  q <- queryNet(network, 'FinalLULC', evidence)
#  head(q)

## ---- eval=FALSE---------------------------------------------------------
#  target <- 'FinalLULC'
#  statesProb <- queryNet(network, target, evidence)
#  maps <- mapTarget(target, statesProb, msk=currentLU)
#  maps
#  
#  par(mfrow=c(1,2))
#  plot(maps$Class, main='Most likely land use class')
#  plot(maps$Entropy, main='Uncertainty (Shannon index)')

