% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.network.R
\name{contrast.network.data}
\alias{contrast.network.data}
\title{Make a network object for contrast-level data containing data, priors, and a JAGS model file}
\usage{
contrast.network.data(
  Outcomes,
  Treat,
  SE,
  na,
  V = NULL,
  type = "random",
  rank.preference = "higher",
  mean.d = 0,
  prec.d = 1e-04,
  hy.prior = list("dunif", 0, 100)
)
}
\arguments{
\item{Outcomes}{A vector of Contrast-level outcomes. Outcome is assumed to be normally distributed. If there are three arms in a trial, need to include two contrast values for that trial. See parkinsons_contrast data for an example.}

\item{Treat}{A vector of treatments for each arm. Treatments should have positive integer values starting from 1 to total number of treatments.}

\item{SE}{A vector of standard error for each contrasts.}

\item{na}{A vector of number of arms in each study.}

\item{V}{Needed if you have multi-arm trials. Length of this vector should be number of studies. If the study is multi-arm trial, need to specify variance of the baseline treatment in that trial. Denote it with NA if the study only has two-arm trials.}

\item{type}{Type of model fitted: either "random" for random effects model or "fixed" for fixed effects model. Default is "random".}

\item{rank.preference}{Set it equal to "higher" if higher values are preferred (i.e. assumes events are good). Set it equal to "lower" if lower values are preferred (i.e. assumes events are bad). Default is "higher".}

\item{mean.d}{Prior mean for the relative effect}

\item{prec.d}{Prior precision for the relative effect}

\item{hy.prior}{Prior for the heterogeneity parameter. Supports uniform, gamma, and half normal for normal. It should be a list of length 3, where first element should be the distribution (one of dunif, dgamma, dhnorm, dwish) and the next two are the parameters associated with the distribution. For example, list("dunif", 0, 5) give uniform prior with lower bound 0 and upper bound 5 for the heterogeneity parameter.}
}
\value{
Creates list of variables that are used to run the model using \code{\link{contrast.network.run}}
}
\description{
This is similar to the function \code{\link{network.data}}, except it uses contrast-level data instead of arms-level data. Contrast-level format uses treatment differences relative to the control arm.
Note that in two arm trials there is only one contrast value per trial, but in three arm trials there are two contrast values relative to the control arm.
}
\examples{
network <- with(parkinsons_contrast, {
 contrast.network.data(Outcomes, Treat, SE, na, V)
})
}
\references{
A.J. Franchini, S. Dias, A.E. Ades, J.P. Jansen, N.J. Welton (2012), \emph{Accounting for correlation in network meta-analysis with multi-arm trials}, Research Synthesis Methods 3(2):142-160. [\url{https://doi.org/10.1002/jrsm.1049}]

S. Dias, A.J. Sutton, A.E. Ades, and N.J. Welton (2013a), \emph{A Generalized Linear Modeling Framework for Pairwise and Network Meta-analysis of Randomized Controlled Trials}, Medical Decision Making 33(5):607-617. [\url{https://doi.org/10.1177/0272989X12458724}]
}
