% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/earthquake.R
\docType{data}
\name{earthquake}
\alias{earthquake}
\title{earthquake Bayesian Network}
\format{
A discrete Bayesian network for estimating the delays in maritime transportation to island communities in British Columbia, resulting from a major earthquake in the region. Probabilities were given within the referenced paper. The vertices are:
\describe{
\item{AD}{Arrival-related delays (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{BSA}{Bridge safety assessment required (Yes, No);}
\item{BSD}{Bathymetric survey required - destination (Yes, No);}
\item{BSO}{Bathymetric survey required - origin (Yes, No);}
\item{BVOR}{Bridge over navigation route (Yes, No);}
\item{CIDD}{Communication infrastructure damage - destination (Low, Medium, High);}
\item{CIDO}{Communication infrastructure damage - origin (Low, Medium, High);}
\item{CN}{Community needs (Low, Medium, High);}
\item{CSR}{Communication system restauration required (Yes, No);}
\item{DAC}{Delay due to arranging crew members (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{DD}{Departure-related delays (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{DDG}{Delay in dangerous goods reporting (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{DGR}{Dangerous good reporting required (Yes, No);}
\item{DL}{Destination location (V_Isl_W, V_Isl_E, V_Isl_S);}
\item{DTWD}{Delay due to tsunami warning - destination (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{DTWO}{Delay due to tsunami warning - origin (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{EEL}{Earthquake epicentre location (V_Isl_W_offshore, V_Isl_E_offshore, V_Isl_Inland, BC_ML);}
\item{ESD}{Earthquake severity - destination (VI_or_less, VII, VIII, IX, X_or_more);}
\item{ESO}{Earthquake severity - origin (VI_or_less, VII, VIII, IX, X_or_more);}
\item{ESR}{Earthquake severity - regional (VI_or_less, VII, VIII, IX, X_or_more);}
\item{MMSC}{Mandatory minimum ship crew required (Yes, No);}
\item{OL}{Origin location (V_Isl_W, V_Isl_E, V_Isl_S, BC_ML);}
\item{PAD}{Personnel availability - destination (Low, Medium, High);}
\item{PAO}{Personnel availability - origin (Low, Medium, High);}
\item{RD}{Route delay (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{TBS}{Time required for bridge safety assessment (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{TBSD}{Time required for bathymetric survey - destination (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{TBSO}{Time required for bathymetric survey - origin (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{TCSD}{Time required for communication system restauration - destination (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{TCSO}{Time required for communication system restauration - origin (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{TIDD}{Terminal infrastructure damage - destination (Low, Medium, High);}
\item{TIDO}{Terminal infrastructure damage - origin (Low, Medium, High);}
\item{TTRD}{Time required for terminal recovery ops - destination (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{TTRO}{Time required for terminal recovery ops - origin (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{TWD}{Tsunami warning - destination (Yes, No);}
\item{TWO}{Tsunami warning - origin (Yes, No);}
\item{VD}{Voyage-related delays (L0, B0_6, B6_12, B12_24, B24_48, M48);}
\item{VT}{Vessel type (BC_Ferries, Seaspan, Barge);}
\item{WIDD}{Waterway infrastructure damage - destination (Low, Medium, High);}
\item{WIDO}{Waterway infrastructure damage - origin (Low, Medium, High);}
}
}
\value{
An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
}
\description{
A Bayesian Network risk model for estimating coastal maritime transportation delays following an earthquake in British Columbia.
}
\references{
Goerlandt, F., & Islam, S. (2021). A Bayesian Network risk model for estimating coastal maritime transportation delays following an earthquake in British Columbia. Reliability Engineering & System Safety, 214, 107708.
}
