// Generated by rstantools.  Do not edit by hand.

/*
    bmstdr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmstdr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmstdr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_spatial_model_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'spatial_model', line 20, column 2 to column 17)",
                                                      " (in 'spatial_model', line 21, column 2 to column 25)",
                                                      " (in 'spatial_model', line 22, column 2 to column 16)",
                                                      " (in 'spatial_model', line 23, column 2 to column 23)",
                                                      " (in 'spatial_model', line 27, column 7 to column 8)",
                                                      " (in 'spatial_model', line 27, column 0 to column 18)",
                                                      " (in 'spatial_model', line 28, column 7 to column 8)",
                                                      " (in 'spatial_model', line 28, column 0 to column 15)",
                                                      " (in 'spatial_model', line 29, column 7 to column 8)",
                                                      " (in 'spatial_model', line 29, column 10 to column 11)",
                                                      " (in 'spatial_model', line 29, column 0 to column 15)",
                                                      " (in 'spatial_model', line 30, column 7 to column 8)",
                                                      " (in 'spatial_model', line 30, column 10 to column 11)",
                                                      " (in 'spatial_model', line 30, column 0 to column 19)",
                                                      " (in 'spatial_model', line 31, column 0 to column 7)",
                                                      " (in 'spatial_model', line 34, column 0 to column 19)",
                                                      " (in 'spatial_model', line 37, column 5 to column 54)",
                                                      " (in 'spatial_model', line 36, column 18 to line 38, column 4)",
                                                      " (in 'spatial_model', line 36, column 3 to line 38, column 4)",
                                                      " (in 'spatial_model', line 39, column 4 to column 38)",
                                                      " (in 'spatial_model', line 35, column 16 to line 40, column 3)",
                                                      " (in 'spatial_model', line 35, column 1 to line 40, column 3)",
                                                      " (in 'spatial_model', line 41, column 1 to column 31)",
                                                      " (in 'spatial_model', line 43, column 1 to column 40)",
                                                      " (in 'spatial_model', line 44, column 1 to column 54)",
                                                      " (in 'spatial_model', line 45, column 1 to column 48)",
                                                      " (in 'spatial_model', line 47, column 1 to column 39)",
                                                      " (in 'spatial_model', line 4, column 0 to column 15)",
                                                      " (in 'spatial_model', line 5, column 0 to column 15)",
                                                      " (in 'spatial_model', line 6, column 7 to column 8)",
                                                      " (in 'spatial_model', line 6, column 0 to column 12)",
                                                      " (in 'spatial_model', line 7, column 7 to column 8)",
                                                      " (in 'spatial_model', line 7, column 10 to column 11)",
                                                      " (in 'spatial_model', line 7, column 0 to column 15)",
                                                      " (in 'spatial_model', line 8, column 7 to column 8)",
                                                      " (in 'spatial_model', line 8, column 10 to column 11)",
                                                      " (in 'spatial_model', line 8, column 0 to column 18)",
                                                      " (in 'spatial_model', line 9, column 0 to column 24)",
                                                      " (in 'spatial_model', line 10, column 0 to column 31)",
                                                      " (in 'spatial_model', line 11, column 0 to column 29)",
                                                      " (in 'spatial_model', line 15, column 2 to column 18)",
                                                      " (in 'spatial_model', line 16, column 9 to column 10)",
                                                      " (in 'spatial_model', line 16, column 2 to column 36)",
                                                      " (in 'spatial_model', line 20, column 9 to column 10)",
                                                      " (in 'spatial_model', line 22, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_spatial_model final : public model_base_crtp<model_spatial_model> {
private:
  int n;
  int p;
  Eigen::Matrix<double, -1, 1> y;
  Eigen::Matrix<double, -1, -1> X;
  Eigen::Matrix<double, -1, -1> dist;
  double phi;
  Eigen::Matrix<double, -1, 1> priorsigma2;
  Eigen::Matrix<double, -1, 1> priortau2;
  double delta;
  Eigen::Matrix<double, -1, 1> mu_0;
 
public:
  ~model_spatial_model() { }
  
  inline std::string model_name() const final { return "model_spatial_model"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_spatial_model(stan::io::var_context& context__,
                      unsigned int random_seed__ = 0,
                      std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_spatial_model_namespace::model_spatial_model";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 28;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 28;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 28;
      current_statement__ = 28;
      check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 29;
      context__.validate_dims("data initialization","p","int",
          context__.to_vec());
      p = std::numeric_limits<int>::min();
      
      current_statement__ = 29;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 29;
      current_statement__ = 29;
      check_greater_or_equal(function__, "p", p, 0);
      current_statement__ = 30;
      validate_non_negative_index("y", "n", n);
      current_statement__ = 31;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(n));
      y = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 31;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 31;
        pos__ = 1;
        current_statement__ = 31;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 31;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 31;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 32;
      validate_non_negative_index("X", "n", n);
      current_statement__ = 33;
      validate_non_negative_index("X", "p", p);
      current_statement__ = 34;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(n, p));
      X = Eigen::Matrix<double, -1, -1>(n, p);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 34;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 34;
        pos__ = 1;
        current_statement__ = 34;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 34;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 34;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 34;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 35;
      validate_non_negative_index("dist", "n", n);
      current_statement__ = 36;
      validate_non_negative_index("dist", "n", n);
      current_statement__ = 37;
      context__.validate_dims("data initialization","dist","double",
          context__.to_vec(n, n));
      dist = Eigen::Matrix<double, -1, -1>(n, n);
      stan::math::fill(dist, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> dist_flat__;
        current_statement__ = 37;
        assign(dist_flat__, nil_index_list(), context__.vals_r("dist"),
          "assigning variable dist_flat__");
        current_statement__ = 37;
        pos__ = 1;
        current_statement__ = 37;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 37;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 37;
            assign(dist,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              dist_flat__[(pos__ - 1)], "assigning variable dist");
            current_statement__ = 37;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 38;
      context__.validate_dims("data initialization","phi","double",
          context__.to_vec());
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 38;
      phi = context__.vals_r("phi")[(1 - 1)];
      current_statement__ = 38;
      current_statement__ = 38;
      check_greater_or_equal(function__, "phi", phi, 0.00001);
      current_statement__ = 39;
      context__.validate_dims("data initialization","priorsigma2","double",
          context__.to_vec(2));
      priorsigma2 = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(priorsigma2, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> priorsigma2_flat__;
        current_statement__ = 39;
        assign(priorsigma2_flat__, nil_index_list(),
          context__.vals_r("priorsigma2"),
          "assigning variable priorsigma2_flat__");
        current_statement__ = 39;
        pos__ = 1;
        current_statement__ = 39;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 39;
          assign(priorsigma2, cons_list(index_uni(sym1__), nil_index_list()),
            priorsigma2_flat__[(pos__ - 1)], "assigning variable priorsigma2");
          current_statement__ = 39;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 39;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 39;
        current_statement__ = 39;
        check_greater_or_equal(function__, "priorsigma2[sym1__]",
                               priorsigma2[(sym1__ - 1)], 0);}
      current_statement__ = 40;
      context__.validate_dims("data initialization","priortau2","double",
          context__.to_vec(2));
      priortau2 = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(priortau2, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> priortau2_flat__;
        current_statement__ = 40;
        assign(priortau2_flat__, nil_index_list(),
          context__.vals_r("priortau2"),
          "assigning variable priortau2_flat__");
        current_statement__ = 40;
        pos__ = 1;
        current_statement__ = 40;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 40;
          assign(priortau2, cons_list(index_uni(sym1__), nil_index_list()),
            priortau2_flat__[(pos__ - 1)], "assigning variable priortau2");
          current_statement__ = 40;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 40;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 40;
        current_statement__ = 40;
        check_greater_or_equal(function__, "priortau2[sym1__]",
                               priortau2[(sym1__ - 1)], 0);}
      current_statement__ = 41;
      delta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 41;
      delta = 1e-5;
      current_statement__ = 42;
      validate_non_negative_index("mu_0", "n", n);
      current_statement__ = 43;
      mu_0 = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(mu_0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 43;
      assign(mu_0, nil_index_list(), rep_vector(0, n),
        "assigning variable mu_0");
      current_statement__ = 44;
      validate_non_negative_index("beta", "p", p);
      current_statement__ = 45;
      validate_non_negative_index("eta", "n", n);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += p;
      num_params_r__ += 1;
      num_params_r__ += n;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_spatial_model_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(p);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 1;
      beta = in__.vector(p);
      local_scalar_t__ sigma_sq;
      sigma_sq = DUMMY_VAR__;
      
      current_statement__ = 2;
      sigma_sq = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        sigma_sq = stan::math::lb_constrain(sigma_sq, 0, lp__);
      } else {
        current_statement__ = 2;
        sigma_sq = stan::math::lb_constrain(sigma_sq, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> eta;
      eta = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(eta, DUMMY_VAR__);
      
      current_statement__ = 3;
      eta = in__.vector(n);
      local_scalar_t__ tau_sq;
      tau_sq = DUMMY_VAR__;
      
      current_statement__ = 4;
      tau_sq = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        tau_sq = stan::math::lb_constrain(tau_sq, 0, lp__);
      } else {
        current_statement__ = 4;
        tau_sq = stan::math::lb_constrain(tau_sq, 0);
      }
      {
        current_statement__ = 5;
        validate_non_negative_index("xbmodel", "n", n);
        Eigen::Matrix<local_scalar_t__, -1, 1> xbmodel;
        xbmodel = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
        stan::math::fill(xbmodel, DUMMY_VAR__);
        
        current_statement__ = 7;
        validate_non_negative_index("dats", "n", n);
        Eigen::Matrix<local_scalar_t__, -1, 1> dats;
        dats = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
        stan::math::fill(dats, DUMMY_VAR__);
        
        current_statement__ = 9;
        validate_non_negative_index("L", "n", n);
        current_statement__ = 10;
        validate_non_negative_index("L", "n", n);
        Eigen::Matrix<local_scalar_t__, -1, -1> L;
        L = Eigen::Matrix<local_scalar_t__, -1, -1>(n, n);
        stan::math::fill(L, DUMMY_VAR__);
        
        current_statement__ = 12;
        validate_non_negative_index("Sigma", "n", n);
        current_statement__ = 13;
        validate_non_negative_index("Sigma", "n", n);
        Eigen::Matrix<local_scalar_t__, -1, -1> Sigma;
        Sigma = Eigen::Matrix<local_scalar_t__, -1, -1>(n, n);
        stan::math::fill(Sigma, DUMMY_VAR__);
        
        local_scalar_t__ u;
        u = DUMMY_VAR__;
        
        current_statement__ = 16;
        assign(xbmodel, nil_index_list(), multiply(X, beta),
          "assigning variable xbmodel");
        current_statement__ = 22;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 19;
          for (int j = 1; j <= n; ++j) {
            current_statement__ = 17;
            assign(Sigma,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              (sigma_sq *
                stan::math::exp(
                  ((-1 * phi) *
                    rvalue(dist,
                      cons_list(index_uni(i),
                        cons_list(index_uni(j), nil_index_list())), "dist")))),
              "assigning variable Sigma");}
          current_statement__ = 20;
          assign(Sigma,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())),
            (rvalue(Sigma,
               cons_list(index_uni(i),
                 cons_list(index_uni(i), nil_index_list())), "Sigma") +
              delta), "assigning variable Sigma");}
        current_statement__ = 23;
        assign(L, nil_index_list(), cholesky_decompose(Sigma),
          "assigning variable L");
        current_statement__ = 24;
        lp_accum__.add(multi_normal_cholesky_lpdf<propto__>(eta, mu_0, L));
        current_statement__ = 25;
        lp_accum__.add(
          inv_gamma_lpdf<propto__>(sigma_sq, priorsigma2[(1 - 1)],
            priorsigma2[(2 - 1)]));
        current_statement__ = 26;
        lp_accum__.add(
          inv_gamma_lpdf<propto__>(tau_sq, priortau2[(1 - 1)],
            priortau2[(2 - 1)]));
        current_statement__ = 27;
        lp_accum__.add(
          normal_lpdf<propto__>(y, add(xbmodel, eta),
            stan::math::sqrt(tau_sq)));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_spatial_model_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(p);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      beta = in__.vector(p);
      double sigma_sq;
      sigma_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma_sq = in__.scalar();
      current_statement__ = 2;
      sigma_sq = stan::math::lb_constrain(sigma_sq, 0);
      Eigen::Matrix<double, -1, 1> eta;
      eta = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      eta = in__.vector(n);
      double tau_sq;
      tau_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      tau_sq = in__.scalar();
      current_statement__ = 4;
      tau_sq = stan::math::lb_constrain(tau_sq, 0);
      for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_sq);
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        vars__.emplace_back(eta[(sym1__ - 1)]);}
      vars__.emplace_back(tau_sq);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(p);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 1;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 1;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      double sigma_sq;
      sigma_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma_sq = context__.vals_r("sigma_sq")[(1 - 1)];
      double sigma_sq_free__;
      sigma_sq_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma_sq_free__ = stan::math::lb_free(sigma_sq, 0);
      Eigen::Matrix<double, -1, 1> eta;
      eta = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> eta_flat__;
        current_statement__ = 3;
        assign(eta_flat__, nil_index_list(), context__.vals_r("eta"),
          "assigning variable eta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 3;
          assign(eta, cons_list(index_uni(sym1__), nil_index_list()),
            eta_flat__[(pos__ - 1)], "assigning variable eta");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      double tau_sq;
      tau_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      tau_sq = context__.vals_r("tau_sq")[(1 - 1)];
      double tau_sq_free__;
      tau_sq_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      tau_sq_free__ = stan::math::lb_free(tau_sq, 0);
      for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_sq_free__);
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        vars__.emplace_back(eta[(sym1__ - 1)]);}
      vars__.emplace_back(tau_sq_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta");
    names__.emplace_back("sigma_sq");
    names__.emplace_back("eta");
    names__.emplace_back("tau_sq");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(p)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma_sq");
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "tau_sq");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma_sq");
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "tau_sq");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << p << "},\"block\":\"parameters\"},{\"name\":\"sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"parameters\"},{\"name\":\"tau_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << p << "},\"block\":\"parameters\"},{\"name\":\"sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"parameters\"},{\"name\":\"tau_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_spatial_model_namespace::model_spatial_model;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_spatial_model_namespace::profiles__;
}
#endif
#endif
