% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_data.R
\docType{data}
\name{nysptime}
\alias{nysptime}
\title{Daily 8-hour maximum ozone concentration values and three covariates from 28 sites in New York for
the 62 days during the months of July and August, 2006.}
\format{
An object of class \code{data.frame} with 1736 rows and 12 columns.
}
\source{
It is the same as the NYdata set in the spTimer package, 
\insertCite{spTimer;textual}{bmstdr}, 
with two added columns providing the UTM X- and Y- coordinates.
 Each data row is  for a particular site and a day as detailed below.

 @format A data frame with 1736 rows and 12 columns:
\describe{
  \item{s.index}{site index (1 to 28)}
  \item{Longitude}{Longitude of the site}
  \item{Latitude}{Latitude of the site}
  \item{utmx}{UTM X-coordinate of the site}
  \item{utmy}{UTM Y-coordinate of the site}
  \item{Year}{This is 2006 for all the rows}
  \item{Month}{Month taking values 7 for July and 8 for August}
  \item{Day}{Day taking values 1 to 31}
  \item{y8hrmax}{Daily 8-hour maximum ozone concentration value}
  \item{xmaxtemp}{Maximum temperature (degree Celsius)}
  \item{xwdsp}{wind speed (nautical mile per hour)}
  \item{xrh}{Relative humidity}
}
}
\usage{
nysptime
}
\description{
Daily 8-hour maximum ozone concentration values and three covariates from 28 sites in New York for
the 62 days during the months of July and August, 2006.
}
\examples{
head(nysptime)
summary(nysptime[, 9:12])
}
\references{
\insertAllCited{}
}
\keyword{datasets}
