% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_ML.R
\name{roc.stat}
\alias{roc.stat}
\title{Compute statistics for ROC curve plotting}
\usage{
roc.stat(f, y)
}
\arguments{
\item{f}{decision value for each instance}

\item{y}{a logical that specify binary labels}
}
\value{
a data.frame() that compute for each threshold value 'f' roc curve statistics: TP, FP, TN, FN, FPR, TPR, sensitivity, specificity, precision, recall, accuracy
}
\description{
Compute statistics for ROC curve plotting
}
\examples{
  x <- cbind(data.matrix(iris[1:4]))
  y <- ifelse(iris$Species=="versicolor","versicolor","not_versicolor")
  w <- bmrm(rocLoss(x,y),LAMBDA=0.01)
  with(roc.stat(x \%*\% w,y=="versicolor"),plot(FPR,TPR,type="l"))
  with(roc.stat(-x[,2],y=="versicolor"),lines(FPR,TPR,col="blue"))
}
\author{
Julien Prados, adapted from Bob Horton code
}
