% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{SDMdist}
\alias{SDMdist}
\alias{dsdm}
\alias{psdm}
\alias{qsdm}
\alias{rsdm}
\title{Distribution functions for the Signal Discrimination Model (SDM)}
\usage{
dsdm(x, mu = 0, c = 3, kappa = 3.5, log = FALSE, parametrization = "sqrtexp")

psdm(
  q,
  mu = 0,
  c = 3,
  kappa = 3.5,
  lower.tail = TRUE,
  log.p = FALSE,
  lower.bound = -pi,
  parametrization = "sqrtexp"
)

qsdm(p, mu = 0, c = 3, kappa = 3.5, parametrization = "sqrtexp")

rsdm(n, mu = 0, c = 3, kappa = 3.5, parametrization = "sqrtexp")
}
\arguments{
\item{x}{Vector of quantiles}

\item{mu}{Vector of location values in radians}

\item{c}{Vector of memory strength values}

\item{kappa}{Vector of precision values}

\item{log}{Logical; if \code{TRUE}, values are returned on the log scale.}

\item{parametrization}{Character; either \code{"bessel"} or \code{"sqrtexp"}
(default). See \href{https://venpopov.github.io/bmm/articles/bmm_sdm_simple.html}{the online article} for details on the
parameterization.}

\item{q}{Vector of quantiles}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x). Else,
return P(X > x)}

\item{log.p}{Logical; if \code{TRUE}, probabilities are returned on the log
scale.}

\item{lower.bound}{Numeric; Lower bound of integration for the cumulative
distribution}

\item{p}{Vector of probabilities}

\item{n}{Number of observations to sample}
}
\value{
\code{dsdm} gives the density, \code{psdm} gives the distribution
function, \code{qsdm} gives the quantile function, \code{rsdm} generates
random deviates, and \code{.dsdm_integrate} is a helper function for
calculating the density of the SDM distribution.
}
\description{
Density, distribution function, and random generation for the
Signal Discrimination Model (SDM) Distribution with location \code{mu},
memory strength \code{c}, and precision \code{kappa}. Currently only a
single activation source is supported.
}
\details{
\strong{Parametrization}

See \href{https://venpopov.github.io/bmm/articles/bmm_sdm_simple.html}{the online article} for details on the parameterization.
Oberauer (2023) introduced the SDM with the bessel parametrization. The
sqrtexp parametrization is the default in the \code{bmm} package for
numerical stability and efficiency. The two parametrizations are related by
the functions \code{c_bessel2sqrtexp()} and \code{c_sqrtexp2bessel()}.

\strong{The cumulative distribution function}

Since responses are on the circle, the cumulative distribution function
requires you to choose a lower bound of integration. The default is
\eqn{-\pi}, as for the brms::pvon_mises() function but you can choose any
value in the argument \code{lower_bound} of \code{psdm}. Another useful
choice is the mean of the response distribution minus \eqn{\pi}, e.g.
\code{lower_bound = mu-pi}. This is the default in
\code{circular::pvonmises()}, and it ensures that 50\% of the cumulative
probability mass is below the mean of the response distribution.
}
\examples{
# plot the density of the SDM distribution
x <- seq(-pi,pi,length.out=10000)
plot(x,dsdm(x,0,2,3),type="l", xlim=c(-pi,pi),ylim=c(0,1),
     xlab="Angle error (radians)",
     ylab="density",
     main="SDM density")
lines(x,dsdm(x,0,9,1),col="red")
lines(x,dsdm(x,0,2,8),col="green")
legend("topright",c("c=2, kappa=3.0, mu=0",
                    "c=9, kappa=1.0, mu=0",
                    "c=2, kappa=8, mu=1"),
       col=c("black","red","green"),lty=1, cex=0.8)

# plot the cumulative distribution function of the SDM distribution
p <- psdm(x, mu = 0, c = 3.1, kappa = 5)
plot(x,p,type="l")

# generate random deviates from the SDM distribution and overlay the density
r <- rsdm(10000, mu = 0, c = 3.1, kappa = 5)
d <- dsdm(x, mu = 0, c = 3.1, kappa = 5)
hist(r, breaks=60, freq=FALSE)
lines(x,d,type="l", col="red")
}
\references{
Oberauer, K. (2023). Measurement models for visual working
memory - A factorial model comparison. Psychological Review, 130(3), 841–852
}
\keyword{distribution}
