% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hugo.R
\name{hugo_cmd}
\alias{hugo_cmd}
\alias{hugo_version}
\alias{hugo_available}
\alias{hugo_build}
\alias{new_site}
\alias{new_content}
\alias{new_post}
\alias{hugo_convert}
\alias{hugo_server}
\title{Run Hugo commands}
\usage{
hugo_cmd(...)

hugo_version()

hugo_available(version = "0.0.0", exact = FALSE)

hugo_build(
  local = FALSE,
  args = getOption("blogdown.hugo.args"),
  baseURL = NULL,
  relativeURLs = NULL
)

new_site(
  dir = ".",
  force = NA,
  install_hugo = TRUE,
  format = "yaml",
  sample = TRUE,
  theme = "yihui/hugo-lithium",
  hostname = "github.com",
  theme_example = TRUE,
  empty_dirs = FALSE,
  to_yaml = TRUE,
  netlify = TRUE,
  .Rprofile = TRUE,
  serve = if (interactive()) "ask" else FALSE
)

new_content(path, kind = "", open = interactive())

new_post(
  title,
  kind = "",
  open = interactive(),
  author = getOption("blogdown.author"),
  categories = NULL,
  tags = NULL,
  date = Sys.Date(),
  file = NULL,
  slug = NULL,
  title_case = getOption("blogdown.title_case"),
  subdir = getOption("blogdown.subdir", "post"),
  ext = getOption("blogdown.ext", ".md")
)

hugo_convert(to = c("YAML", "TOML", "JSON"), unsafe = FALSE, ...)

hugo_server(host, port)
}
\arguments{
\item{...}{Arguments to be passed to \code{system2('hugo', ...)}, e.g.
\code{new_content(path)} is basically \code{hugo_cmd(c('new', path))} (i.e.
run the command \command{hugo new path}).}

\item{version}{A version number.}

\item{exact}{If \code{FALSE}, check if the current Hugo version is equal to
or higher than the specified \code{version}. If \code{TRUE}, check if the
exact version is available.}

\item{local}{Whether to build the site for local preview (if \code{TRUE}, all
drafts and future posts will also be built).}

\item{args}{A character vector of command-line arguments to be passed to
\command{hugo}, e.g., \code{c("--minify", "--quiet")}.}

\item{baseURL, relativeURLs}{Custom values of \code{baseURL} and
\code{relativeURLs} to override Hugo's default and the settings in the
site's config file.}

\item{dir}{The directory of the new site.}

\item{force}{Whether to create the site in a directory even if it is not
empty. By default, \code{force = TRUE} when the directory only contains
hidden, RStudio project (\file{*.Rproj}), \file{LICENSE}, and/or
\file{README} files.}

\item{install_hugo}{Whether to install Hugo automatically if it is not found.}

\item{format}{The format of the configuration file. Note that the frontmatter
of the new (R) Markdown file created by \code{new_content()} always uses
YAML instead of TOML or JSON.}

\item{sample}{Whether to add sample content. Hugo creates an empty site by
default, but this function adds sample content by default.}

\item{theme}{A Hugo theme on Github (a character string of the form
\code{user/repo}, and you can optionally specify a GIT branch or tag name
after \code{@}, i.e. \code{theme} can be of the form
\code{user/repo@branch}). You can also specify a full URL to the zip file
or tarball of the theme. If \code{theme = NA}, no themes will be installed,
and you have to manually install a theme.}

\item{hostname}{Where to find the theme. Defaults to \code{github.com};
specify if you wish to use an instance of GitHub Enterprise. You can also
specify the full URL of the zip file or tarball in \code{theme}, in which
case this argument is ignored.}

\item{theme_example}{Whether to copy the example in the \file{exampleSite}
directory if it exists in the theme. Not all themes provide example sites.}

\item{empty_dirs}{Whether to keep the empty directories generated by Hugo.}

\item{to_yaml}{Whether to convert the metadata of all posts to YAML.}

\item{netlify}{Whether to create a Netlify config file \file{netlify.toml}.}

\item{.Rprofile}{Whether to create a \file{.Rprofile} file. If \code{TRUE}, a
sample \file{.Rprofile} will be created. It contains some global options,
such as \code{options(blogdown.hugo.version)}, which makes sure you will
use a specific version of Hugo for this site in the future.}

\item{serve}{Whether to start a local server to serve the site. By default,
this function will ask you in an interactive R session if you want to serve
the site.}

\item{path}{The path to the new file under the \file{content} directory.}

\item{kind}{The content type to create, i.e., the Hugo archetype. If the
archetype is a page bundle archetype, it should end with a slash, e.g.,
\code{post/}.}

\item{open}{Whether to open the new file after creating it. By default, it is
opened in an interactive R session.}

\item{title}{The title of the post.}

\item{author}{The author of the post.}

\item{categories}{A character vector of category names.}

\item{tags}{A character vector of tag names.}

\item{date}{The date of the post.}

\item{file}{The filename of the post. By default, the filename will be
automatically generated from the title by replacing non-alphanumeric
characters with dashes, e.g. \code{title = 'Hello World'} may create a file
\file{content/post/2016-12-28-hello-world.md}. The date of the form
\code{YYYY-mm-dd} will be prepended if the filename does not start with a
date.}

\item{slug}{The slug of the post. By default (\code{NULL}), the slug is
generated from the filename by removing the date and filename extension,
e.g., if \code{file = 'post/2020-07-23-hi-there.md'}, \code{slug} will be
\code{hi-there}. Set \code{slug = ''} if you do not want it.}

\item{title_case}{A function to convert the title to title case. If
\code{TRUE}, the function is \code{tools::\link[tools]{toTitleCase}()}).
This argument is not limited to title case conversion. You can provide an
arbitrary R function to convert the title.}

\item{subdir}{If specified (not \code{NULL}), the post will be generated
under a subdirectory under \file{content/}. It can be a nested subdirectory
like \file{post/joe/}.}

\item{ext}{The filename extension (e.g., \file{.md}, \file{.Rmd}, or
\file{.Rmarkdown}). Ignored if \code{file} has been specified.}

\item{to}{A format to convert to.}

\item{unsafe}{Whether to enable unsafe operations, such as overwriting
Markdown source documents. If you have backed up the website, or the
website is under version control, you may try \code{unsafe = TRUE}.}

\item{host, port}{The host IP address and port; see
\code{servr::\link{server_config}()}.}
}
\description{
Wrapper functions to run Hugo commands via \code{\link{system2}('hugo',
...)}.
}
\section{Functions}{
\itemize{
\item \code{hugo_cmd}: Run an arbitrary Hugo command.

\item \code{hugo_version}: Return the version number of Hugo if possible, which is
extracted from the output of \code{hugo_cmd('version')}.

\item \code{hugo_available}: Check if Hugo of a certain version (or above if
\code{exact = FALSE}) is available.

\item \code{hugo_build}: Build a plain Hugo website. Note that the function
\code{\link{build_site}()} first compiles Rmd files, and then calls Hugo
via \code{hugo_build()} to build the site.

\item \code{new_site}: Create a new site (skeleton) via \command{hugo new
site}. The directory of the new site should be empty,

\item \code{new_content}: Create a new (R) Markdown file via \command{hugo new}
(e.g. a post or a page).

\item \code{new_post}: A wrapper function to create a new post under the
\file{content/post/} directory via \code{new_content()}. If your post will
use R code chunks, you can set \code{ext = '.Rmd'} or the global option
\code{options(blogdown.ext = '.Rmd')} in your \file{~/.Rprofile}.
Similarly, you can set \code{options(blogdown.author = 'Your Name')} so
that the author field is automatically filled out when creating a new post.

\item \code{hugo_convert}: A wrapper function to convert source content to
different formats via \command{hugo convert}.

\item \code{hugo_server}: Start a Hugo server.
}}

\examples{
blogdown::hugo_available("1.2.3")
if (interactive()) blogdown::new_site()
}
\references{
The full list of Hugo commands: \url{https://gohugo.io/commands},
  and themes: \url{https://themes.gohugo.io}.
}
