% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabsel.R
\name{stab.blockSeg}
\alias{stab.blockSeg}
\title{stab.blockSeg algorithm}
\usage{
stab.blockSeg(Y, nsimu, max.break, max.var = floor(ncol(Y)^2/8),
  mc.cores = 2, verbose = TRUE)
}
\arguments{
\item{Y}{matrix of observations.}

\item{nsimu}{a positive integer.}

\item{max.break}{a positive integer less than number of columns divided by 2 and number of rows divided by 2.}

\item{max.var}{a positive integer less than number of columns times number of rows.
By default, ncol(Y)**2/8.}

\item{mc.cores}{a positive integer giving the number of cores used. If you use windows, the parallelization is impossible.
By default, 2}

\item{verbose}{logical. To display each step. By default TRUE.}
}
\description{
Model selection for the blockSeg algorithm.
}
\examples{
 ## model parameters 
n <- 100 
K <- 5
mu <- suppressWarnings(matrix(rep(c(1,0),ceiling(K**2/2)), K,K))
Y <- rblockdata(n,mu,sigma=.5)$Y
res <- stab.blockSeg(Y, 100, 20)

}

