% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unlistCluInt.R
\encoding{UTF-8}
\name{unlistCluInt}
\alias{unlistCluInt}
\title{Unlist a partition.}
\usage{
unlistCluInt(clu)
}
\arguments{
\item{clu}{A partition by sets, that is a list of "simple" partitions.}
}
\value{
The unlisted partition - one vector containing only integers.
}
\description{
It is used to convert a partition by sets into a single "simple" partition. Simple partition is a partition of only one set, that is a vector where units with the same value are considered to belong to the same cluster. The partitions by sets is a list, where each element of a list is a "simple" partition that corresponds to one set. The function first converts all elements of the lists to integers, that makes sure that each set uses different integers and on the end uses unlist function on such list.
}
\examples{
cluList<-list(c("a","b","a"),c("b","c","b","c"))
unlistCluInt(cluList)

cluList<-list(c(1,1,1,2,2,2),c(1,1,1,2,2,2,3,3))
unlistCluInt(cluList)
}
\seealso{
\code{\link{clu}},  \code{\link{splitClu}}, \code{\link{unlistClu}}
}
