% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/blatr.R
\name{blat}
\alias{blat}
\title{Send Emails Using Blat for Windows}
\usage{
blat(...)
}
\arguments{
\item{...}{arguments to blat}
}
\description{
This is a wrapper which calls Blat to send emails. For documentation on the
options, see \url{http://www.blat.net/syntax/syntax.html}. You should not use
dashes as part of the argument names (as with Blat), this is done for you:
simply use \code{name = value} pairs as arguments. For some basic examples
of the most commonly used arguments, see below.
}
\details{
Blat can use a file as body of the email, in which case this is ordinarily
the first argument in the Blat command. However, \code{blatr} uses the named
argument \code{filename} to specify this. Unnamed arguments do not work with
blatr.
}
\examples{
\dontrun{
   # With attachment
   blat(f      = "Your Name <your@email.com>",
        to     = "your-recipients@email.com",
        s      = "The subject",
        server = "server.address",
        attach = "C:/path/to/attachment.txt",
        body   = "The text you wish to send.")

   # With file as body
   blat(f        = "Your Name <your@email.com>",
        to       = "your-recipients@email.com",
        s        = "The subject",
        server   = "server.address",
        attach   = "C:/path/to/attachment.txt",
        filename = "C:/path/to/file/with/body.txt")

   # With username and password required.
   blat(f        = "Your Name <your@email.com>",
        to       = "your-recipients@email.com",
        s        = "The subject",
        server   = "server.address",
        attach   = "C:/path/to/attachment.txt",
        filename = "C:/path/to/file/with/body.txt",
        u        = "username",
        pw       = "password")
}
}

