% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-calendars.R
\name{other-calendars}
\alias{other-calendars}
\alias{load_quantlib_calendars}
\alias{load_rmetrics_calendars}
\title{Calendars from other packages}
\usage{
load_quantlib_calendars(ql_calendars = NULL, from, to, financial = TRUE)

load_rmetrics_calendars(year, financial = TRUE)
}
\arguments{
\item{ql_calendars}{(QuantLib only) A character vector with the names of 
QuantLib's calendars. This parameter defaults to NULL, which loads all 
calendars.}

\item{from}{(QuantLib only) the start date}

\item{to}{(QuantLib only) the end date}

\item{financial}{is a logical argument that defaults to TRUE.}

\item{year}{(timeDate Rmetrics only) a vector with years to create the 
calendars.}
}
\description{
The packages RQuantLib and timeDate (Rmetrics) have functions to compute 
business days between 2 dates according to a predefined calendar.
bizdays creates calendars based on these functions.
}
\details{
To load QuantLib's calendars use \code{load_quantlib_calendars} defining 
which
calendar has to be loaded by its name and the range of dates the calendar 
has to handle.
All QuantLib calendars have the \code{QuantLib} prefix.

To load Rmetrics' calendars use \code{load_rmetrics_calendars} defining the 
years the calendar has to handle.
All Rmetrics calendars have the \code{Rmetrics} prefix.
}
\section{Financial calendars}{


This argument defines the calendar as a financial or a non financial calendar.
Financial calendars don't consider the ending business day when counting working days in \code{bizdays}.
In QuantLib, Financial calendars are those that \code{includeLast} is set to \code{FALSE}.
}

\section{List of calendars}{


QuantLib Calendars:

\itemize{
\item QuantLib/TARGET
\item QuantLib/Argentina
\item QuantLib/Australia
\item QuantLib/Brazil
\item QuantLib/Canada
\item QuantLib/Canada/Settlement
\item QuantLib/Canada/TSX
\item QuantLib/China
\item QuantLib/CzechRepublic
\item QuantLib/Denmark
\item QuantLib/Finland
\item QuantLib/Germany
\item QuantLib/Germany/FrankfurtStockExchange
\item QuantLib/Germany/Settlement
\item QuantLib/Germany/Xetra
\item QuantLib/Germany/Eurex
\item QuantLib/HongKong
\item QuantLib/Hungary
\item QuantLib/Iceland
\item QuantLib/India
\item QuantLib/Indonesia
\item QuantLib/Italy
\item QuantLib/Italy/Settlement
\item QuantLib/Italy/Exchange
\item QuantLib/Japan
\item QuantLib/Mexico
\item QuantLib/NewZealand
\item QuantLib/Norway
\item QuantLib/Poland
\item QuantLib/Russia
\item QuantLib/SaudiArabia
\item QuantLib/Singapore
\item QuantLib/Slovakia
\item QuantLib/SouthAfrica
\item QuantLib/SouthKorea
\item QuantLib/SouthKorea/KRX
\item QuantLib/Sweden
\item QuantLib/Switzerland
\item QuantLib/Taiwan
\item QuantLib/Turkey
\item QuantLib/Ukraine
\item QuantLib/UnitedKingdom
\item QuantLib/UnitedKingdom/Settlement
\item QuantLib/UnitedKingdom/Exchange
\item QuantLib/UnitedKingdom/Metals
\item QuantLib/UnitedStates
\item QuantLib/UnitedStates/Settlement
\item QuantLib/UnitedStates/NYSE
\item QuantLib/UnitedStates/GovernmentBond
\item QuantLib/UnitedStates/NERC
}

Rmetrics Calendars:

\itemize{
\item Calendar Rmetrics/LONDON
\item Calendar Rmetrics/NERC
\item Calendar Rmetrics/NYSE
\item Calendar Rmetrics/TSX
\item Calendar Rmetrics/ZURICH
}
}

\examples{
if (require("RQuantLib")) {
 # loading Argentina calendar
 load_quantlib_calendars('Argentina', from='2016-01-01', to='2016-12-31')
 bizdays('2016-01-01', '2016-03-14', 'QuantLib/Argentina')
 # loading 2 calendars
 load_quantlib_calendars(c('UnitedStates/NYSE', 'UnitedKingdom/Settlement'),
                         from='2016-01-01', to='2016-12-31')
 bizdays('2016-01-01', '2016-03-14', 'QuantLib/UnitedStates/NYSE')
 # loading all QuantLib's 50 calendars
 load_quantlib_calendars(from='2016-01-01', to='2016-12-31')
 bizdays('2016-01-01', '2016-03-14', 'QuantLib/Brazil')
}

if (require("timeDate")) {
 # loading all Rmetrics calendar
 load_rmetrics_calendars(2016)
 bizdays('2016-01-01', '2016-03-14', 'Rmetrics/NERC')
 bizdays('2016-01-01', '2016-03-14', 'Rmetrics/NYSE')
}
}
