% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt.bases.R
\name{wt.bases}
\alias{wt.bases}
\title{Compute wavelet}
\usage{
wt.bases(mother = "morlet", ...)
}
\arguments{
\item{mother}{type of mother wavelet function to use. Can be set to
\code{morlet}, \code{dog}, or \code{paul}. Default is \code{morlet}.}

\item{...}{see parameters \code{k}, \code{scale} and \code{param} in
functions: \code{\link{wt.bases.morlet}}, \code{\link{wt.bases.paul}} and
          \code{\link{wt.bases.dog}}}
}
\value{
Returns a list containing:
\item{daughter}{wavelet function}
\item{fourier.factor}{ratio of fourier period to scale}
\item{coi}{cone of influence}
\item{dof}{degrees of freedom for each point in wavelet power}
}
\description{
Computes the wavelet as a function of Fourier frequency.
}
\examples{
# Not run: wb <- wt.bases(mother, k, scale[a1], param)

}
\author{
Tarik C. Gouhier (tarik.gouhier@gmail.com)

Code based on wavelet MATLAB program written by Christopher Torrence and
Gibert P. Compo.
}
\references{
Torrence, C., and G. P. Compo. 1998. A Practical Guide to Wavelet Analysis. 
\emph{Bulletin of the American Meteorological Society} 79:61-78.
}

