% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lengths.R
\name{bm_heights}
\alias{bm_heights}
\alias{bm_heights.bm_matrix}
\alias{bm_heights.bm_list}
\alias{bm_heights.magick-image}
\alias{bm_heights.nativeRaster}
\alias{bm_heights.raster}
\alias{bm_widths}
\alias{bm_widths.bm_matrix}
\alias{bm_widths.bm_list}
\alias{bm_widths.magick-image}
\alias{bm_widths.nativeRaster}
\alias{bm_widths.raster}
\title{Widths or heights of bitmaps}
\usage{
bm_heights(x, ...)

\method{bm_heights}{bm_matrix}(x, ...)

\method{bm_heights}{bm_list}(x, unique = TRUE, ...)

\method{bm_heights}{`magick-image`}(x, ...)

\method{bm_heights}{nativeRaster}(x, ...)

\method{bm_heights}{raster}(x, ...)

bm_widths(x, ...)

\method{bm_widths}{bm_matrix}(x, ...)

\method{bm_widths}{bm_list}(x, unique = TRUE, ...)

\method{bm_widths}{`magick-image`}(x, ...)

\method{bm_widths}{nativeRaster}(x, ...)

\method{bm_widths}{raster}(x, ...)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{"magick-image"}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{"raster"}  object.}

\item{...}{Ignored.}

\item{unique}{Apply \code{\link[base:unique]{base::unique()}} to the returned integer vector.}
}
\value{
A integer vector of the relevant length of each
of the bitmap objects in \code{x}.
If \code{unique} is \code{TRUE} then any duplicates will have been removed.
}
\description{
\code{bm_widths()} returns the widths of the bitmaps while
\code{bm_heights()} returns the heights of the bitmaps.
\code{bm_widths()} and \code{bm_heights()} are S3 generic functions.
}
\examples{
font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
font <- read_hex(font_file)
bm_widths(font) # every glyph in the font is 8 pixels wide
bm_heights(font) # every glyph in the font is 16 pixels high
corn <- farming_crops_16x16()$corn$portrait
bm_widths(corn)
bm_heights(corn)
}
