% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lengths.R
\name{bm_widths}
\alias{bm_widths}
\alias{bm_heights}
\title{Widths or heights of bitmaps}
\usage{
bm_widths(bm_object, unique = TRUE)

bm_heights(bm_object, unique = TRUE)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{unique}{Apply \code{\link[base:unique]{base::unique()}} to the returned integer vector.}
}
\value{
A integer vector of the relevant length of each
of the \code{bm_bitmap()} objects in \code{x}.
If \code{unique} is \code{TRUE} then any duplicates will have been removed.
}
\description{
\code{bm_widths()} returns the widths of the bitmaps while
\code{bm_heights()} returns the heights of the bitmaps.
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  bm_widths(font) # every glyph in the font is 8 pixels wide
  bm_heights(font) # every glyph in the font is 16 pixels high
}
