% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_font.R
\name{bm_font}
\alias{bm_font}
\title{Bitmap font object}
\usage{
bm_font(x = bm_list(), comments = NULL, properties = NULL)
}
\arguments{
\item{x}{Named list of \code{\link[=bm_bitmap]{bm_bitmap()}} objects.
Names must be coercible by \code{\link[Unicode:u_char_basics]{Unicode::as.u_char()}}.}

\item{comments}{An optional character vector of (global) font comments.}

\item{properties}{An optional named list of font metadata.}
}
\value{
A named list with a \dQuote{bm_font} subclass.
}
\description{
\code{bm_font()} creates a bitmap font object.
}
\details{
\code{bm_font()} is a named list.
The names are of the form \dQuote{U+HHHH} or \dQuote{U+HHHHH}.
where the \code{H} are appropriate hexadecimal Unicode code points.
It is a subclass of \code{\link[=bm_list]{bm_list()}}.
}
\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)
 is_bm_font(font)

 # number of characters in font
 length(font)

 # print out "R"
 R_glyph <- font[[str2ucp("R")]]
 print(R_glyph, px = c(".", "#"))
}
\seealso{
\code{\link[=is_bm_font]{is_bm_font()}}, [as_bm_font(), \code{\link[=hex2ucp]{hex2ucp()}}]
}
