% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_trades.R
\name{tn_map_trades}
\alias{tn_map_trades}
\title{Trade data over an extended period (testnet)}
\usage{
tn_map_trades(
  symbol = "XBTUSD",
  start_date = "2019-01-01 12:00:00",
  end_date = "2019-01-01 12:15:00",
  filter = NULL,
  use_auth = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{symbol}{a character string for the instrument symbol.
Use \code{\link[=available_symbols]{available_symbols()}} to see available symbols.}

\item{start_date}{character string.
Starting date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{end_date}{character string.
Ending date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{filter}{an optional character string for table filtering.
Send JSON key/value pairs, such as \code{"{'key':'value'}"}. See examples in \code{\link[=trades]{trades()}}.}

\item{use_auth}{logical. Use \code{TRUE} to enable authentication with API key.}

\item{verbose}{logical. If \code{TRUE}, will print information to the console. Useful for
long running requests.}
}
\description{
The map variant of \code{\link[=tn_trades]{tn_trades()}} uses a repeat loop to continually
request trade data between two time points.
The function will stop when the \code{start_date} is greater than \code{end_date}.
}
\examples{
\donttest{

# Get all trade data between 2019-05-03 12:00:00 and 2019-05-03 12:15:00

tn_map_trades(
  start_date = "2019-05-03 12:00:00",
  end_date = "2019-05-03 12:15:00",
  symbol = "XBTUSD"
)
}

}
\concept{tn_trades}
